/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory.personalstorage;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import mekanism.api.AutomationType;
import mekanism.api.DataHandlerUtils;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.MekanismSavedData;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageData;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageItemInventory;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class PersonalStorageManager {
    private static final Map<UUID, PersonalStorageData> STORAGE_BY_PLAYER_UUID = new HashMap<UUID, PersonalStorageData>();

    private static PersonalStorageData forOwner(UUID playerUUID) {
        return STORAGE_BY_PLAYER_UUID.computeIfAbsent(playerUUID, uuid -> MekanismSavedData.createSavedData(PersonalStorageData::new, "personal_storage" + File.separator + uuid));
    }

    public static PersonalStorageItemInventory getInventoryFor(ItemStack stack) {
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)stack);
        if (owner == null) {
            throw new IllegalStateException("Stack has no owner!");
        }
        UUID invId = PersonalStorageManager.getInventoryId(stack);
        PersonalStorageItemInventory storageItemInventory = PersonalStorageManager.forOwner(owner).getOrAddInventory(invId);
        ListTag legacyData = ItemDataUtils.getList(stack, "Items");
        if (!legacyData.isEmpty()) {
            DataHandlerUtils.readContainers(storageItemInventory.getInventorySlots(null), legacyData);
            ItemDataUtils.removeData(stack, "Items");
        }
        return storageItemInventory;
    }

    public static Optional<PersonalStorageItemInventory> getInventoryIfPresent(ItemStack stack) {
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)stack);
        UUID invId = PersonalStorageManager.getInventoryIdNullable(stack);
        boolean hasLegacyData = ItemDataUtils.hasData(stack, "Items", 9);
        return Optional.ofNullable(owner != null && (invId != null || hasLegacyData) ? PersonalStorageManager.getInventoryFor(stack) : null);
    }

    public static void deleteInventory(ItemStack stack) {
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)stack);
        UUID invId = PersonalStorageManager.getInventoryIdNullable(stack);
        if (owner != null && invId != null) {
            PersonalStorageManager.forOwner(owner).removeInventory(invId);
        }
    }

    @NotNull
    private static UUID getInventoryId(ItemStack stack) {
        UUID invId = PersonalStorageManager.getInventoryIdNullable(stack);
        if (invId == null) {
            invId = UUID.randomUUID();
            ItemDataUtils.setUUID(stack, "personalStorageId", invId);
        }
        return invId;
    }

    @Nullable
    private static UUID getInventoryIdNullable(ItemStack stack) {
        return ItemDataUtils.getUniqueID(stack, "personalStorageId");
    }

    public static void reset() {
        STORAGE_BY_PLAYER_UUID.clear();
    }

    public static void createSlots(Consumer<IInventorySlot> slotConsumer, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInteract, IContentsListener listener) {
        for (int slotY = 0; slotY < 6; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                slotConsumer.accept(BasicInventorySlot.at(canInteract, canInteract, listener, 8 + slotX * 18, 18 + slotY * 18));
            }
        }
    }
}

