/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.processors;

import java.util.Map;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.UpgradeUtils;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NBTProcessor
public class MekanismContentsProcessor
implements INBTProcessor {
    public String getName() {
        return "MekanismContentsProcessor";
    }

    public String getDescription() {
        return "Increases the EMC value of any Mekanism items by the value of the stored or installed contents.";
    }

    public long recalculateEMC(@NotNull ItemInfo info, long currentEMC) throws ArithmeticException {
        BlockItem blockItem;
        Item storedContents;
        IEMCProxy emcProxy = ProjectEAPI.getEMCProxy();
        ItemStack stack = info.createStack();
        Object object = stack.m_41720_();
        if (object instanceof IItemSustainedInventory) {
            IItemSustainedInventory sustainedInventory = (IItemSustainedInventory)object;
            storedContents = sustainedInventory.getSustainedInventory(stack);
            for (IInventorySlot iInventorySlot : ItemRecipeData.readContents((ListTag)storedContents)) {
                if (iInventorySlot.isEmpty()) continue;
                currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, iInventorySlot.getStack());
            }
        }
        if ((storedContents = stack.m_41720_()) instanceof BlockItem && Attribute.has((blockItem = (BlockItem)storedContents).m_40614_(), AttributeUpgradeSupport.class) && ItemDataUtils.hasData(stack, "componentUpgrade", 10)) {
            Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getCompound(stack, "componentUpgrade"));
            for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, UpgradeUtils.getStack(entry.getKey(), entry.getValue()));
            }
        }
        if ((object = stack.m_41720_()) instanceof IModuleContainerItem) {
            IModuleContainerItem moduleContainerItem = (IModuleContainerItem)object;
            for (Module module : moduleContainerItem.getModules(stack)) {
                ItemStack itemStack = module.getData().getItemProvider().getItemStack(module.getInstalledCount());
                currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, itemStack);
            }
        }
        return currentEMC;
    }

    private static long addEmc(IEMCProxy emcProxy, long currentEMC, ItemStack stack) throws ArithmeticException {
        long itemEmc = emcProxy.getValue(stack);
        if (itemEmc > 0L) {
            long stackEmc = Math.multiplyExact(itemEmc, stack.m_41613_());
            currentEMC = Math.addExact(currentEMC, stackEmc);
        }
        return currentEMC;
    }
}

