/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import java.util.List;
import java.util.function.Predicate;
import mekanism.common.entity.EntityRobit;
import mekanism.common.entity.ai.RobitAIBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;

public class RobitAIPickup
extends RobitAIBase {
    private static final int SEARCH_RADIUS = 10;
    private static final int SEARCH_RADIUS_SQ = 100;
    private final Predicate<Entity> itemPredicate = entity -> {
        ItemEntity item;
        return !entity.m_5833_() && entity instanceof ItemEntity && this.theRobit.isItemValid(item = (ItemEntity)entity);
    };
    private ItemEntity closest;

    public RobitAIPickup(EntityRobit entityRobit, float speed) {
        super(entityRobit, speed);
    }

    public boolean m_8036_() {
        if (!this.theRobit.getDropPickup()) {
            return false;
        }
        PathNavigation navigator = this.getNavigator();
        if (this.validateClosest() && navigator.m_6570_((Entity)this.closest, 0) != null) {
            return true;
        }
        this.closest = null;
        double closestDistance = -1.0;
        List items = this.theRobit.m_9236_().m_6443_(ItemEntity.class, new AABB(this.theRobit.m_20185_() - 10.0, this.theRobit.m_20186_() - 10.0, this.theRobit.m_20189_() - 10.0, this.theRobit.m_20185_() + 10.0, this.theRobit.m_20186_() + 10.0, this.theRobit.m_20189_() + 10.0), this.itemPredicate);
        for (ItemEntity entity : items) {
            double distance = this.theRobit.m_20280_((Entity)entity);
            if (!(distance <= 100.0) || closestDistance != -1.0 && !(distance < closestDistance) || navigator.m_6570_((Entity)entity, 0) == null) continue;
            this.closest = entity;
            closestDistance = distance;
        }
        return this.closest != null;
    }

    private boolean validateClosest() {
        return this.closest != null && this.theRobit.isItemValid(this.closest) && this.closest.m_9236_().m_46472_() == this.theRobit.m_9236_().m_46472_() && this.theRobit.m_20280_((Entity)this.closest) <= 100.0;
    }

    public boolean m_8045_() {
        return this.theRobit.getDropPickup() && this.validateClosest() && !this.getNavigator().m_26571_() && !this.theRobit.getEnergyContainer().isEmpty();
    }

    public void m_8037_() {
        if (this.theRobit.getDropPickup()) {
            this.updateTask((Entity)this.closest);
        }
    }
}

