/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.function.IntSupplier;
import mekanism.api.gear.IHUDElement;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HUDElement
implements IHUDElement {
    private final ResourceLocation icon;
    private final Component text;
    private final HUDColor color;

    private HUDElement(ResourceLocation icon, Component text, HUDColor color) {
        this.icon = icon;
        this.text = text;
        this.color = color;
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public Component getText() {
        return this.text;
    }

    @Override
    public int getColor() {
        return this.color.getColorARGB();
    }

    public static HUDElement of(ResourceLocation icon, Component text, HUDColor color) {
        return new HUDElement(icon, text, color);
    }

    public static enum HUDColor {
        REGULAR(MekanismConfig.client.hudColor),
        FADED(() -> REGULAR.getColor().darken(0.5).rgb()),
        WARNING(MekanismConfig.client.hudWarningColor),
        DANGER(MekanismConfig.client.hudDangerColor);

        private final IntSupplier color;

        private HUDColor(IntSupplier color) {
            this.color = color;
        }

        public Color getColor() {
            return Color.rgb(this.color.getAsInt()).alpha(MekanismConfig.client.hudOpacity.get());
        }

        public int getColorARGB() {
            return this.getColor().argb();
        }

        public static HUDColor from(IHUDElement.HUDColor apiColor) {
            return switch (apiColor) {
                default -> throw new IncompatibleClassChangeError();
                case IHUDElement.HUDColor.REGULAR -> REGULAR;
                case IHUDElement.HUDColor.FADED -> FADED;
                case IHUDElement.HUDColor.WARNING -> WARNING;
                case IHUDElement.HUDColor.DANGER -> DANGER;
            };
        }
    }
}

