/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import mekanism.api.RelativeSide;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRadialSelector;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.armor.ISpecialGear;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.client.render.hud.RadiationOverlay;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeCustomSelectionBox;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderTickHandler {
    public final Minecraft minecraft = Minecraft.m_91087_();
    private static final Map<BlockState, List<Vertex[]>> cachedWireFrames = new HashMap<BlockState, List<Vertex[]>>();
    private static final Map<Direction, Map<TransmissionType, MekanismRenderer.Model3D>> cachedOverlays = new EnumMap<Direction, Map<TransmissionType, MekanismRenderer.Model3D>>(Direction.class);
    private static final Map<RenderType, List<LazyRender>> transparentRenderers = new HashMap<RenderType, List<LazyRender>>();
    private static final BoltRenderer boltRenderer = new BoltRenderer();
    private boolean outliningArea = false;

    public static void clearQueued() {
        RadiationOverlay.INSTANCE.resetRadiation();
        transparentRenderers.clear();
    }

    public static void resetCached() {
        cachedOverlays.clear();
        cachedWireFrames.clear();
    }

    public static void renderBolt(Object renderer, BoltEffect bolt) {
        boltRenderer.update(renderer, bolt, MekanismRenderer.getPartialTick());
    }

    public static void guiOpening(ScreenEvent.Opening event) {
        Screen screen = event.getCurrentScreen();
        if (screen instanceof GuiMekanism) {
            GuiMekanism screen2 = (GuiMekanism)screen;
            if (event.getNewScreen() instanceof IRecipesGui) {
                screen2.switchingToJEI = true;
            }
        }
    }

    public static void addTransparentRenderer(RenderType renderType, LazyRender render) {
        transparentRenderers.computeIfAbsent(renderType, r -> new ArrayList()).add(render);
    }

    @SubscribeEvent
    public void renderWorld(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            this.renderStage(event, !transparentRenderers.isEmpty(), (camera, renderer, poseStack, renderTick, partialTick) -> {
                ProfilerFiller profiler = this.minecraft.m_91307_();
                profiler.m_6180_("delayedMekanismTranslucentBERs");
                record TransparentRenderInfo(RenderType renderType, List<LazyRender> renders, double closest) {
                }
                Consumer<TransparentRenderInfo> renderInfoConsumer = info -> {
                    VertexConsumer buffer = renderer.m_6299_(info.renderType);
                    for (LazyRender transparentRender : info.renders) {
                        String profilerSection = transparentRender.getProfilerSection();
                        if (profilerSection != null) {
                            profiler.m_6180_(profilerSection);
                        }
                        transparentRender.render(camera, buffer, poseStack, renderTick, partialTick, profiler);
                        if (profilerSection == null) continue;
                        profiler.m_7238_();
                    }
                    renderer.m_109912_(info.renderType);
                };
                if (transparentRenderers.size() == 1) {
                    for (Map.Entry<RenderType, List<LazyRender>> entry2 : transparentRenderers.entrySet()) {
                        renderInfoConsumer.accept(new TransparentRenderInfo(entry2.getKey(), entry2.getValue(), 0.0));
                    }
                } else {
                    transparentRenderers.entrySet().stream().map(entry -> {
                        List renders = (List)entry.getValue();
                        double closest = Double.MAX_VALUE;
                        for (LazyRender render : renders) {
                            double distanceSqr;
                            Vec3 renderPos = render.getCenterPos(partialTick);
                            if (renderPos == null || !((distanceSqr = camera.m_90583_().m_82557_(renderPos)) < closest)) continue;
                            closest = distanceSqr;
                        }
                        return new TransparentRenderInfo((RenderType)entry.getKey(), renders, closest);
                    }).sorted(Comparator.comparingDouble(info -> -info.closest)).forEachOrdered(renderInfoConsumer);
                }
                transparentRenderers.clear();
                profiler.m_7238_();
            });
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && boltRenderer.hasBoltsToRender()) {
            this.renderStage(event, boltRenderer.hasBoltsToRender(), (camera, renderer, poseStack, renderTick, partialTick) -> {
                boltRenderer.render(partialTick, poseStack, (MultiBufferSource)renderer);
                renderer.m_109912_(MekanismRenderType.MEK_LIGHTNING);
            });
        }
    }

    private void renderStage(RenderLevelStageEvent event, boolean shouldRender, StageRenderer renderer) {
        if (shouldRender) {
            Camera camera = event.getCamera();
            PoseStack matrix = event.getPoseStack();
            matrix.m_85836_();
            Vec3 camVec = camera.m_90583_();
            matrix.m_85837_(-camVec.f_82479_, -camVec.f_82480_, -camVec.f_82481_);
            renderer.render(camera, this.minecraft.m_91269_().m_110104_(), matrix, event.getRenderTick(), event.getPartialTick());
            matrix.m_85849_();
        }
    }

    @SubscribeEvent
    public void renderCrosshair(RenderGuiOverlayEvent.Pre event) {
        GuiRadialSelector screen;
        Screen screen2;
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && (screen2 = this.minecraft.f_91080_) instanceof GuiRadialSelector && (screen = (GuiRadialSelector)screen2).shouldHideCrosshair()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        Item item = chestStack.m_41720_();
        if (item instanceof ItemMekaSuitArmor) {
            boolean rightHand;
            ItemMekaSuitArmor armorItem = (ItemMekaSuitArmor)item;
            MekaSuitArmor armor = (MekaSuitArmor)((ISpecialGear)IClientItemExtensions.of((Item)armorItem)).getGearModel(ArmorItem.Type.CHESTPLATE);
            PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
            PlayerModel model = (PlayerModel)renderer.m_7200_();
            model.m_8009_(true);
            boolean bl = rightHand = event.getArm() == HumanoidArm.RIGHT;
            if (rightHand) {
                model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
            } else {
                model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
            }
            model.f_102608_ = 0.0f;
            model.f_102817_ = false;
            model.f_102818_ = 0.0f;
            model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            armor.renderArm((HumanoidModel<? extends LivingEntity>)model, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), OverlayTexture.f_118083_, (LivingEntity)player, chestStack, rightHand);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.minecraft.f_91074_ != null && this.minecraft.f_91074_.m_9236_() != null && !this.minecraft.m_91104_() && this.minecraft.f_91072_ != null) {
            Player p;
            LocalPlayer player = this.minecraft.f_91074_;
            Level world = this.minecraft.f_91074_.m_9236_();
            for (UUID uuid : Mekanism.playerState.getActiveJetpacks()) {
                float xRot;
                p = world.m_46003_(uuid);
                if (p == null) continue;
                Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, p.m_20192_(), 0.0);
                Vec3 playerMotion = p.m_20184_();
                float random = (world.f_46441_.m_188501_() - 0.5f) * 0.1f;
                if (p.m_6047_()) {
                    xRot = 20.0f;
                    playerPos = playerPos.translate(0.0, 0.125, 0.0);
                } else {
                    float f = p.m_20998_(event.renderTickTime);
                    if (p.m_21255_()) {
                        float f1 = (float)p.m_21256_() + event.renderTickTime;
                        float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                        xRot = f2 * (-90.0f - p.m_146909_());
                    } else {
                        float f3 = p.m_20069_() ? -90.0f - p.m_146909_() : -90.0f;
                        xRot = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
                    }
                    xRot = -xRot;
                    Pos3D eyeAdjustments = p.m_21255_() && (p != player || !this.minecraft.f_91066_.m_92176_().m_90612_()) ? new Pos3D(0.0, p.m_20236_(Pose.STANDING), 0.0).xRot(xRot).yRot(p.f_20883_) : (p.m_6067_() ? new Pos3D(0.0, p.m_20192_(), 0.0).xRot(xRot).yRot(p.f_20883_).translate(0.0, 0.5, 0.0) : new Pos3D(0.0, p.m_20192_(), 0.0).xRot(xRot).yRot(p.f_20883_));
                    playerPos = new Pos3D(p.m_20185_() + eyeAdjustments.f_82479_, p.m_20186_() + eyeAdjustments.f_82480_, p.m_20189_() + eyeAdjustments.f_82481_);
                }
                Pos3D vLeft = new Pos3D(-0.43, -0.55, -0.54).xRot(xRot).yRot(p.f_20883_);
                this.renderJetpackSmoke(world, playerPos.translate(vLeft, playerMotion), vLeft.scale(0.2).translate(playerMotion, vLeft.scale(random)));
                Pos3D vRight = new Pos3D(0.43, -0.55, -0.54).xRot(xRot).yRot(p.f_20883_);
                this.renderJetpackSmoke(world, playerPos.translate(vRight, playerMotion), vRight.scale(0.2).translate(playerMotion, vRight.scale(random)));
                Pos3D vCenter = new Pos3D(((double)world.f_46441_.m_188501_() - 0.5) * 0.4, -0.86, -0.3).xRot(xRot).yRot(p.f_20883_);
                this.renderJetpackSmoke(world, playerPos.translate(vCenter, playerMotion), vCenter.scale(0.2).translate(playerMotion));
            }
            if (world.m_46467_() % 4L == 0L) {
                for (UUID uuid : Mekanism.playerState.getActiveScubaMasks()) {
                    p = world.m_46003_(uuid);
                    if (p == null || !p.m_20069_()) continue;
                    Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(p.m_20252_(1.0f)).translate(0.0, -0.2, 0.0);
                    Pos3D motion = vec.scale(0.2).translate(p.m_20184_());
                    Pos3D v = new Pos3D((Entity)p).translate(0.0, p.m_20192_(), 0.0).translate((Vec3)vec);
                    world.m_7106_((ParticleOptions)MekanismParticleTypes.SCUBA_BUBBLE.get(), v.f_82479_, v.f_82480_, v.f_82481_, motion.f_82479_, motion.f_82480_ + 0.2, motion.f_82481_);
                }
                for (Player p2 : world.m_6907_()) {
                    Pos3D flameVec;
                    boolean rightHanded;
                    ItemStack currentItem;
                    if (p2.f_20911_ || Mekanism.playerState.isFlamethrowerOn(p2) || (currentItem = p2.m_21205_()).m_41619_() || !(currentItem.m_41720_() instanceof ItemFlamethrower) || !ChemicalUtil.hasGas(currentItem)) continue;
                    boolean bl = rightHanded = p2.m_5737_() == HumanoidArm.RIGHT;
                    if (player == p2 && this.minecraft.f_91066_.m_92176_().m_90612_()) {
                        flameVec = new Pos3D(1.0, 1.0, 1.0).multiply(p2.m_20252_(event.renderTickTime)).yRot(rightHanded ? 15.0f : -15.0f).translate(0.0, (double)p2.m_20192_() - 0.1, 0.0);
                    } else {
                        double flameXCoord = rightHanded ? -0.2 : 0.2;
                        double flameYCoord = 1.0;
                        double flameZCoord = 1.2;
                        if (p2.m_6047_()) {
                            flameYCoord -= 0.65;
                            flameZCoord -= 0.15;
                        }
                        flameVec = new Pos3D(flameXCoord, flameYCoord, flameZCoord).yRot(p2.f_20883_);
                    }
                    Vec3 motion = p2.m_20184_();
                    Vec3 flameMotion = new Vec3(motion.m_7096_(), p2.m_20096_() ? 0.0 : motion.m_7098_(), motion.m_7094_());
                    Vec3 mergedVec = p2.m_20182_().m_82549_((Vec3)flameVec);
                    world.m_7106_((ParticleOptions)MekanismParticleTypes.JETPACK_FLAME.get(), mergedVec.f_82479_, mergedVec.f_82480_, mergedVec.f_82481_, flameMotion.f_82479_, flameMotion.f_82480_, flameMotion.f_82481_);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockHover(RenderHighlightEvent.Block event) {
        LocalPlayer player = this.minecraft.f_91074_;
        if (player == null) {
            return;
        }
        BlockHitResult rayTraceResult = event.getTarget();
        if (rayTraceResult.m_6662_() != HitResult.Type.MISS) {
            IBlastingItem tool;
            Map<BlockPos, BlockState> blocks;
            Item item;
            ItemStack stack;
            Level world = player.m_9236_();
            BlockPos pos = rayTraceResult.m_82425_();
            MultiBufferSource renderer = event.getMultiBufferSource();
            Camera info = event.getCamera();
            PoseStack matrix = event.getPoseStack();
            ProfilerFiller profiler = world.m_46473_();
            BlockState blockState = world.m_8055_(pos);
            profiler.m_6180_("areaMineOutline");
            if (!this.outliningArea && !(stack = player.m_21205_()).m_41619_() && (item = stack.m_41720_()) instanceof IBlastingItem && !(blocks = (tool = (IBlastingItem)item).getBlastedBlocks(world, (Player)player, stack, pos, blockState)).isEmpty()) {
                this.outliningArea = true;
                Vec3 renderView = info.m_90583_();
                LevelRenderer levelRenderer = event.getLevelRenderer();
                Lazy lineConsumer = Lazy.of(() -> renderer.m_6299_(RenderType.m_110504_()));
                for (Map.Entry<BlockPos, BlockState> block : blocks.entrySet()) {
                    BlockPos blastingTarget = block.getKey();
                    if (pos.equals((Object)blastingTarget) || ForgeHooksClient.onDrawHighlight((LevelRenderer)levelRenderer, (Camera)info, (HitResult)rayTraceResult, (float)event.getPartialTick(), (PoseStack)matrix, (MultiBufferSource)renderer)) continue;
                    levelRenderer.m_109637_(matrix, (VertexConsumer)lineConsumer.get(), (Entity)player, renderView.f_82479_, renderView.f_82480_, renderView.f_82481_, blastingTarget, block.getValue());
                }
                this.outliningArea = false;
            }
            profiler.m_7238_();
            boolean shouldCancel = false;
            profiler.m_6180_("mekOutline");
            if (!blockState.m_60795_() && world.m_6857_().m_61937_(pos)) {
                AttributeCustomSelectionBox customSelectionBox;
                TileEntityBoundingBlock tile;
                BlockPos actualPos = pos;
                BlockState actualState = blockState;
                if (blockState.m_60734_() instanceof BlockBounding && (tile = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (BlockGetter)world, pos)) != null && tile.hasReceivedCoords()) {
                    actualPos = tile.getMainPos();
                    actualState = world.m_8055_(actualPos);
                }
                if ((customSelectionBox = Attribute.get(actualState, AttributeCustomSelectionBox.class)) != null) {
                    WireFrameRenderer renderWireFrame = null;
                    if (customSelectionBox.isJavaModel()) {
                        IWireFrameRenderer wireFrameRenderer;
                        BlockEntityRenderer tileRenderer;
                        BlockEntity tile2 = WorldUtils.getTileEntity((BlockGetter)world, actualPos);
                        if (tile2 != null && (tileRenderer = Minecraft.m_91087_().m_167982_().m_112265_(tile2)) instanceof IWireFrameRenderer && (wireFrameRenderer = (IWireFrameRenderer)tileRenderer).hasSelectionBox(actualState)) {
                            renderWireFrame = (buffer, matrixStack, state, red, green, blue, alpha) -> {
                                if (wireFrameRenderer.isCombined()) {
                                    this.renderQuadsWireFrame(state, buffer, matrixStack.m_85850_().m_252922_(), world.f_46441_, red, green, blue, alpha);
                                }
                                wireFrameRenderer.renderWireFrame(tile2, event.getPartialTick(), matrixStack, buffer, red, green, blue, alpha);
                            };
                        }
                    } else {
                        renderWireFrame = (buffer, matrixStack, state, red, green, blue, alpha) -> this.renderQuadsWireFrame(state, buffer, matrixStack.m_85850_().m_252922_(), world.f_46441_, red, green, blue, alpha);
                    }
                    if (renderWireFrame != null) {
                        matrix.m_85836_();
                        Vec3 viewPosition = info.m_90583_();
                        matrix.m_85837_((double)actualPos.m_123341_() - viewPosition.f_82479_, (double)actualPos.m_123342_() - viewPosition.f_82480_, (double)actualPos.m_123343_() - viewPosition.f_82481_);
                        renderWireFrame.render(renderer.m_6299_(RenderType.m_110504_()), matrix, actualState, 0, 0, 0, 102);
                        matrix.m_85849_();
                        shouldCancel = true;
                    }
                }
            }
            profiler.m_7238_();
            ItemStack stack2 = player.m_21205_();
            if (!(!stack2.m_41619_() && stack2.m_41720_() instanceof ItemConfigurator || !(stack2 = player.m_21206_()).m_41619_() && stack2.m_41720_() instanceof ItemConfigurator)) {
                if (shouldCancel) {
                    event.setCanceled(true);
                }
                return;
            }
            profiler.m_6180_("configurableMachine");
            ItemConfigurator.ConfiguratorMode state2 = (ItemConfigurator.ConfiguratorMode)((ItemConfigurator)stack2.m_41720_()).getMode(stack2);
            if (state2.isConfigurating()) {
                ISideConfiguration configurable;
                TileComponentConfig config;
                TransmissionType type = Objects.requireNonNull(state2.getTransmission(), "Configurating state requires transmission type");
                BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
                if (tile instanceof ISideConfiguration && (config = (configurable = (ISideConfiguration)tile).getConfig()).supports(type)) {
                    Direction face = rayTraceResult.m_82434_();
                    DataType dataType = config.getDataType(type, RelativeSide.fromDirections(configurable.getDirection(), face));
                    if (dataType != null) {
                        Vec3 viewPosition = info.m_90583_();
                        matrix.m_85836_();
                        matrix.m_85837_((double)pos.m_123341_() - viewPosition.f_82479_, (double)pos.m_123342_() - viewPosition.f_82480_, (double)pos.m_123343_() - viewPosition.f_82481_);
                        MekanismRenderer.renderObject(this.getOverlayModel(face, type), matrix, renderer.m_6299_(Sheets.m_110792_()), MekanismRenderer.getColorARGB(dataType.getColor(), 0.6f), 0xF000F0, OverlayTexture.f_118083_, RenderResizableCuboid.FaceDisplay.FRONT, info);
                        matrix.m_85849_();
                    }
                }
            }
            profiler.m_7238_();
            if (shouldCancel) {
                event.setCanceled(true);
            }
        }
    }

    private void renderQuadsWireFrame(BlockState state, VertexConsumer buffer, Matrix4f matrix, RandomSource rand, int red, int green, int blue, int alpha) {
        List allVertices = cachedWireFrames.computeIfAbsent(state, s -> {
            BakedModel bakedModel = Minecraft.m_91087_().m_91289_().m_110910_(s);
            ModelData modelData = ModelData.EMPTY;
            ArrayList vertices = new ArrayList();
            for (Direction direction : EnumUtils.DIRECTIONS) {
                QuadUtils.unpack(bakedModel.getQuads(s, direction, rand, modelData, null)).stream().map(Quad::getVertices).forEach(vertices::add);
            }
            QuadUtils.unpack(bakedModel.getQuads(s, null, rand, modelData, null)).stream().map(Quad::getVertices).forEach(vertices::add);
            return vertices;
        });
        RenderTickHandler.renderVertexWireFrame(allVertices, buffer, matrix, red, green, blue, alpha);
    }

    public static void renderVertexWireFrame(List<Vertex[]> allVertices, VertexConsumer buffer, Matrix4f matrix, int red, int green, int blue, int alpha) {
        for (Vertex[] vertices : allVertices) {
            Vector4f vertex = RenderTickHandler.getVertex(matrix, vertices[0]);
            Vector3f normal = vertices[0].getNormal();
            Vector4f vertex2 = RenderTickHandler.getVertex(matrix, vertices[1]);
            Vector3f normal2 = vertices[1].getNormal();
            Vector4f vertex3 = RenderTickHandler.getVertex(matrix, vertices[2]);
            Vector3f normal3 = vertices[2].getNormal();
            Vector4f vertex4 = RenderTickHandler.getVertex(matrix, vertices[3]);
            Vector3f normal4 = vertices[3].getNormal();
            buffer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_6122_(red, green, blue, alpha).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
            buffer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_6122_(red, green, blue, alpha).m_5601_(normal2.x(), normal2.y(), normal2.z()).m_5752_();
            buffer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_6122_(red, green, blue, alpha).m_5601_(normal3.x(), normal3.y(), normal3.z()).m_5752_();
            buffer.m_5483_((double)vertex4.x(), (double)vertex4.y(), (double)vertex4.z()).m_6122_(red, green, blue, alpha).m_5601_(normal4.x(), normal4.y(), normal4.z()).m_5752_();
            buffer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_6122_(red, green, blue, alpha).m_5601_(normal2.x(), normal2.y(), normal2.z()).m_5752_();
            buffer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_6122_(red, green, blue, alpha).m_5601_(normal3.x(), normal3.y(), normal3.z()).m_5752_();
            buffer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_6122_(red, green, blue, alpha).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
            buffer.m_5483_((double)vertex4.x(), (double)vertex4.y(), (double)vertex4.z()).m_6122_(red, green, blue, alpha).m_5601_(normal4.x(), normal4.y(), normal4.z()).m_5752_();
        }
    }

    private static Vector4f getVertex(Matrix4f matrix4f, Vertex vertex) {
        Vector4f vector4f = new Vector4f((float)vertex.getPos().m_7096_(), (float)vertex.getPos().m_7098_(), (float)vertex.getPos().m_7094_(), 1.0f);
        return vector4f.mul((Matrix4fc)matrix4f);
    }

    private void renderJetpackSmoke(Level world, Vec3 pos, Vec3 motion) {
        world.m_7106_((ParticleOptions)MekanismParticleTypes.JETPACK_FLAME.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        world.m_7106_((ParticleOptions)MekanismParticleTypes.JETPACK_SMOKE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    private MekanismRenderer.Model3D getOverlayModel(Direction side, TransmissionType type) {
        return cachedOverlays.computeIfAbsent(side, s -> new EnumMap(TransmissionType.class)).computeIfAbsent(type, t -> new MekanismRenderer.Model3D().setTexture(MekanismRenderer.overlays.get(t)).prepSingleFaceModelSize(side));
    }

    @FunctionalInterface
    private static interface StageRenderer {
        public void render(Camera var1, MultiBufferSource.BufferSource var2, PoseStack var3, int var4, float var5);
    }

    @FunctionalInterface
    private static interface WireFrameRenderer {
        public void render(VertexConsumer var1, PoseStack var2, BlockState var3, int var4, int var5, int var6, int var7);
    }

    @FunctionalInterface
    public static interface LazyRender {
        public void render(Camera var1, VertexConsumer var2, PoseStack var3, int var4, float var5, ProfilerFiller var6);

        @Nullable
        default public Vec3 getCenterPos(float partialTick) {
            return null;
        }

        @Nullable
        default public String getProfilerSection() {
            return null;
        }
    }
}

