/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class CreateTaskAtMessage
extends BaseC2SMessage {
    private final long chapterId;
    private final double x;
    private final double y;
    private final TaskType type;
    private final CompoundTag nbt;

    public CreateTaskAtMessage(Chapter chapter, double x, double y, Task task) {
        this.chapterId = chapter.id;
        this.x = x;
        this.y = y;
        this.type = task.getType();
        this.nbt = new CompoundTag();
        task.writeData(this.nbt);
    }

    CreateTaskAtMessage(FriendlyByteBuf buffer) {
        this.chapterId = buffer.readLong();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.type = ServerQuestFile.INSTANCE.getTaskType(buffer.m_130242_());
        this.nbt = buffer.m_130260_();
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CREATE_TASK_AT;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.chapterId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.m_130130_(this.type.internalId);
        buffer.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerQuestFile file;
        Chapter ch;
        if (NetUtils.canEdit(context) && (ch = (file = ServerQuestFile.INSTANCE).getChapter(this.chapterId)) != null) {
            Quest quest = new Quest(file.newID(), ch);
            quest.setX(this.x);
            quest.setY(this.y);
            quest.onCreated();
            new CreateObjectResponseMessage(quest, null).sendToAll(context.getPlayer().m_20194_());
            Task task = this.type.createTask(file.newID(), quest);
            task.readData(this.nbt);
            task.onCreated();
            CompoundTag extra = new CompoundTag();
            extra.m_128359_("type", this.type.getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(context.getPlayer().m_20194_());
            file.refreshIDMap();
            file.clearCachedData();
            file.markDirty();
        }
    }
}

