/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class AddTaskButton
extends Button {
    private final Quest quest;

    public AddTaskButton(Panel panel, Quest quest) {
        super(panel, (Component)Component.m_237115_((String)"gui.add"), (Icon)ThemeProperties.ADD_ICON.get());
        this.quest = quest;
        this.setSize(18, 18);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (TaskType type : TaskTypes.TYPES.values()) {
            contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIconSupplier(), () -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, task -> {
                    CompoundTag extra = new CompoundTag();
                    extra.m_128359_("type", type.getTypeForNBT());
                    new CreateObjectMessage((QuestObjectBase)task, extra).sendToServer();
                });
            }));
        }
        String clip = AddTaskButton.getClipboardString();
        if (!clip.isEmpty()) {
            try {
                long taskId = Long.valueOf(clip, 16);
                QuestObject questObject = FTBQuestsAPI.api().getQuestFile(true).get(taskId);
                if (questObject instanceof Task) {
                    Task task = (Task)questObject;
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                    contextMenu.add(new PasteTaskMenuItem(task, () -> this.copyAndCreateTask(task)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.getGui().openContextMenu(contextMenu);
    }

    private void copyAndCreateTask(Task task) {
        Task newTask = QuestObjectBase.copy(task, () -> TaskType.createTask(0L, this.quest, task.getType().getTypeId().toString()));
        if (newTask != null) {
            CompoundTag extra = new CompoundTag();
            extra.m_128359_("type", newTask.getType().getTypeForNBT());
            new CreateObjectMessage(newTask, extra).sendToServer();
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public static class PasteTaskMenuItem
    extends TooltipContextMenuItem {
        public PasteTaskMenuItem(Task task, @Nullable Runnable callback) {
            super((Component)Component.m_237115_((String)"ftbquests.gui.paste_task"), Icons.ADD, callback, new Component[]{Component.m_237113_((String)"\"").m_7220_(task.getTitle()).m_130946_("\""), Component.m_237113_((String)QuestObjectBase.getCodeString(task.id)).m_130940_(ChatFormatting.DARK_GRAY)});
        }
    }
}

