/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.MultilineTextBox;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.client.gui.quests.ViewQuestPanel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class MultilineTextEditorScreen
extends BaseScreen {
    private static final Pattern STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)&[0-9A-FK-OR]");
    private static final int MAX_UNDO = 10;
    private final Component title;
    private final ListConfig<String, StringConfig> config;
    private final ConfigCallback callback;
    private final Panel outerPanel;
    private final Panel toolbarPanel;
    private final Panel textBoxPanel;
    private final MultilineTextBox textBox;
    private final PanelScrollBar scrollBar;
    private long ticksOpen = 0L;
    private long lastChange = 0L;
    private final Deque<HistoryElement> redoStack = new ArrayDeque<HistoryElement>();
    private final Map<Integer, Runnable> hotKeys = Map.of(66, () -> this.insertFormatting(ChatFormatting.BOLD), 73, () -> this.insertFormatting(ChatFormatting.ITALIC), 85, () -> this.insertFormatting(ChatFormatting.UNDERLINE), 83, () -> this.insertFormatting(ChatFormatting.STRIKETHROUGH), 82, this::resetFormatting, 80, () -> this.insertAtEndOfLine("\n{@pagebreak}"), 77, this::openImageSelector, 90, this::undoLast);

    public MultilineTextEditorScreen(Component title, ListConfig<String, StringConfig> config, ConfigCallback callback) {
        this.title = title;
        this.config = config;
        this.callback = callback;
        this.outerPanel = new OuterPanel(this);
        this.toolbarPanel = new ToolbarPanel(this.outerPanel);
        this.textBoxPanel = new TextBoxPanel(this.outerPanel);
        this.textBox = new MultilineTextBox(this.textBoxPanel);
        this.textBox.setText(Strings.join((Iterable)((Iterable)config.getValue()), (String)"\n"));
        this.textBox.setFocused(true);
        this.textBox.setValueListener(this::onValueChanged);
        this.textBox.seekCursor(Whence.ABSOLUTE, 0);
        this.redoStack.addLast(new HistoryElement(this.textBox.getText(), this.textBox.cursorPos()));
        this.scrollBar = new PanelScrollBar(this.outerPanel, ScrollBar.Plane.VERTICAL, this.textBoxPanel);
        this.scrollBar.setScrollStep((double)this.getTheme().getFontHeight());
    }

    private void onValueChanged(String newValue) {
        this.lastChange = Minecraft.m_91087_().f_91073_.m_46467_();
    }

    public void tick() {
        super.tick();
        ++this.ticksOpen;
        if (this.lastChange > 0L && Minecraft.m_91087_().f_91073_.m_46467_() - this.lastChange > 5L) {
            this.redoStack.addLast(new HistoryElement(this.textBox.getText(), this.textBox.cursorPos()));
            while (this.redoStack.size() > 10) {
                this.redoStack.removeFirst();
            }
            this.lastChange = 0L;
        }
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().m_85445_() / 5 * 4);
        this.setHeight(this.getScreen().m_85446_() / 5 * 4);
        this.ticksOpen = 0L;
        return true;
    }

    public void addWidgets() {
        this.add((Widget)this.outerPanel);
    }

    public void alignWidgets() {
        this.outerPanel.setPosAndSize(0, 0, this.width, this.height);
        this.toolbarPanel.setPosAndSize(2, 2, this.width - 4, 18);
        this.toolbarPanel.alignWidgets();
        this.textBoxPanel.setPosAndSize(2, this.toolbarPanel.height + 4, this.width - 18, this.height - this.toolbarPanel.height - 6);
        this.textBoxPanel.alignWidgets();
        this.scrollBar.setPosAndSize(this.width - 14, this.textBoxPanel.posY, 12, this.height - this.textBoxPanel.posY - 4);
    }

    public void drawBackground(GuiGraphics matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, x + (this.width - theme.getStringWidth((FormattedText)this.title)) / 2, y - theme.getFontHeight() - 2, 2);
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.cancel();
            return true;
        }
        if (key.enter() && Screen.m_96638_()) {
            this.saveAndExit();
            return true;
        }
        if (this.executeHotkey(key.keyCode, true)) {
            return true;
        }
        if (this.textBox.isFocused()) {
            this.textBox.keyPressed(key);
            return true;
        }
        return false;
    }

    private boolean executeHotkey(int keycode, boolean checkModifier) {
        if (this.hotKeys.containsKey(keycode) && (!checkModifier || MultilineTextEditorScreen.isHotKeyModifierPressed(keycode))) {
            this.hotKeys.get(keycode).run();
            this.textBox.setFocused(true);
            return true;
        }
        return false;
    }

    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.ticksOpen < 2L) {
            return true;
        }
        char keyCode = Character.toUpperCase(c);
        if (MultilineTextEditorScreen.isHotKeyModifierPressed(keyCode) && this.hotKeys.containsKey(keyCode)) {
            return false;
        }
        return super.charTyped(c, modifiers);
    }

    private static boolean isHotKeyModifierPressed(int keycode) {
        return keycode == 90 ? Screen.m_96637_() : Screen.m_96639_();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private void openImageSelector() {
        int cursor = this.textBox.cursorPos();
        ImageComponent component = new ImageComponent();
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            this.openGui();
            if (accepted) {
                this.textBox.seekCursor(Whence.ABSOLUTE, cursor);
                this.insertAtEndOfLine("\n" + component);
            }
        });
        group.add("image", (ConfigValue)new ImageConfig(), (Object)component.image.toString(), v -> {
            component.image = Icon.getIcon((String)v);
        }, (Object)"");
        group.addInt("width", component.width, v -> {
            component.width = v;
        }, 0, 1, 1000);
        group.addInt("height", component.height, v -> {
            component.height = v;
        }, 0, 1, 1000);
        group.addInt("align", component.align, v -> {
            component.align = v;
        }, 0, 1, 2);
        group.addBool("fit", component.fit, v -> {
            component.fit = v;
        }, false);
        new EditConfigScreen(group).openGui();
    }

    private void cancel() {
        this.callback.save(false);
    }

    private void saveAndExit() {
        ((List)this.config.getValue()).clear();
        Collections.addAll((Collection)this.config.getValue(), this.textBox.getText().split("\n"));
        this.closeGui();
        this.callback.save(true);
    }

    private void insertFormatting(ChatFormatting c) {
        if (this.textBox.hasSelection()) {
            this.textBox.insertText("&" + c.m_178510_() + this.textBox.getSelectedText() + "&r");
        } else {
            this.textBox.insertText("&" + c.m_178510_());
        }
        this.textBox.setFocused(true);
    }

    private void resetFormatting() {
        if (this.textBox.hasSelection()) {
            this.textBox.insertText(MultilineTextEditorScreen.stripFormatting(this.textBox.getSelectedText()));
        } else {
            this.textBox.insertText("&r");
        }
    }

    private static String stripFormatting(@NotNull String selectedText) {
        return STRIP_FORMATTING_PATTERN.matcher(selectedText).replaceAll("");
    }

    private void insertAtEndOfLine(String toInsert) {
        this.textBox.keyPressed(new Key(269, -1, 0));
        this.textBox.insertText(toInsert);
    }

    private void undoLast() {
        if (this.redoStack.size() > 1) {
            this.redoStack.removeLast();
            HistoryElement h = this.redoStack.peekLast();
            this.textBox.setValueListener(s -> {});
            this.textBox.setText(Objects.requireNonNull(h).text());
            this.textBox.setValueListener(this::onValueChanged);
            this.textBox.setSelecting(false);
            this.textBox.seekCursor(Whence.ABSOLUTE, h.cursorPos());
        }
    }

    private class OuterPanel
    extends Panel {
        public OuterPanel(MultilineTextEditorScreen screen) {
            super((Panel)screen);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
        }

        public void addWidgets() {
            this.addAll(List.of(MultilineTextEditorScreen.this.toolbarPanel, MultilineTextEditorScreen.this.textBoxPanel, MultilineTextEditorScreen.this.scrollBar));
        }

        public void alignWidgets() {
        }
    }

    private class ToolbarPanel
    extends Panel {
        private final ToolbarButton acceptButton;
        private final ToolbarButton cancelButton;
        private final ToolbarButton boldButton;
        private final ToolbarButton italicButton;
        private final ToolbarButton underlineButton;
        private final ToolbarButton strikethroughButton;
        private final ToolbarButton colorButton;
        private final ToolbarButton resetButton;
        private final ToolbarButton pageBreakButton;
        private final ToolbarButton imageButton;
        private final ToolbarButton undoButton;

        public ToolbarPanel(Panel outerPanel) {
            super(outerPanel);
            this.acceptButton = new ToolbarButton(this, (Component)Component.m_237115_((String)"gui.accept"), Icons.ACCEPT, MultilineTextEditorScreen.this::saveAndExit).withTooltip(ToolbarPanel.hotkey("Shift + Enter"));
            this.cancelButton = new ToolbarButton(this, (Component)Component.m_237115_((String)"gui.cancel"), Icons.CANCEL, MultilineTextEditorScreen.this::cancel).withTooltip(ToolbarPanel.hotkey("Escape"));
            this.boldButton = new ToolbarButton(this, (Component)Component.m_237113_((String)"B").m_130940_(ChatFormatting.BOLD), () -> MultilineTextEditorScreen.this.executeHotkey(66, false)).withTooltip(ToolbarPanel.hotkey("Alt + B"));
            this.italicButton = new ToolbarButton(this, (Component)Component.m_237113_((String)"I").m_130940_(ChatFormatting.ITALIC), () -> MultilineTextEditorScreen.this.executeHotkey(73, false)).withTooltip(ToolbarPanel.hotkey("Alt + I"));
            this.underlineButton = new ToolbarButton(this, (Component)Component.m_237113_((String)"U").m_130940_(ChatFormatting.UNDERLINE), () -> MultilineTextEditorScreen.this.executeHotkey(85, false)).withTooltip(ToolbarPanel.hotkey("Alt + U"));
            this.strikethroughButton = new ToolbarButton(this, (Component)Component.m_237113_((String)"S").m_130940_(ChatFormatting.STRIKETHROUGH), () -> MultilineTextEditorScreen.this.executeHotkey(83, false)).withTooltip(ToolbarPanel.hotkey("Alt + S"));
            this.colorButton = new ToolbarButton(this, (Component)Component.m_237119_(), Icons.COLOR_RGB, this::openColorContextMenu);
            this.resetButton = new ToolbarButton(this, (Component)Component.m_237113_((String)"r"), () -> MultilineTextEditorScreen.this.executeHotkey(82, false)).withTooltip(new Component[]{Component.m_237115_((String)"ftbquests.gui.clear_formatting"), ToolbarPanel.hotkey("Alt + R")});
            this.pageBreakButton = new ToolbarButton(this, (Component)Component.m_237119_(), ViewQuestPanel.PAGEBREAK_ICON, () -> MultilineTextEditorScreen.this.executeHotkey(80, false)).withTooltip(new Component[]{Component.m_237115_((String)"ftbquests.gui.page_break"), ToolbarPanel.hotkey("Alt + P")});
            this.imageButton = new ToolbarButton(this, (Component)Component.m_237119_(), Icons.ART, () -> MultilineTextEditorScreen.this.executeHotkey(77, false)).withTooltip(new Component[]{Component.m_237115_((String)"ftbquests.chapter.image"), ToolbarPanel.hotkey("Alt + M")});
            this.undoButton = new ToolbarButton(this, (Component)Component.m_237119_(), Icons.REFRESH, () -> MultilineTextEditorScreen.this.executeHotkey(90, false)).withTooltip(new Component[]{Component.m_237115_((String)"ftbquests.gui.undo"), ToolbarPanel.hotkey("Ctrl + Z")});
        }

        private static Component hotkey(String str) {
            return Component.m_237113_((String)("[" + str + "]")).m_130940_(ChatFormatting.DARK_GRAY);
        }

        private void openColorContextMenu() {
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
            for (ChatFormatting cf : ChatFormatting.values()) {
                if (cf.m_126665_() == null) continue;
                items.add(new ContextMenuItem((Component)Component.m_237119_(), (Icon)Color4I.rgb((int)cf.m_126665_()), () -> MultilineTextEditorScreen.this.insertFormatting(cf)));
            }
            ContextMenu cMenu = new ContextMenu((Panel)MultilineTextEditorScreen.this, items);
            cMenu.setMaxRows(4);
            cMenu.setDrawVerticalSeparators(false);
            MultilineTextEditorScreen.this.openContextMenu(cMenu);
        }

        public void tick() {
            this.undoButton.setVisible(MultilineTextEditorScreen.this.redoStack.size() > 1);
        }

        public void addWidgets() {
            this.addAll(List.of(this.acceptButton, this.cancelButton, this.boldButton, this.italicButton, this.underlineButton, this.strikethroughButton, this.colorButton, this.resetButton, this.pageBreakButton, this.imageButton, this.undoButton));
        }

        public void alignWidgets() {
            this.acceptButton.setPosAndSize(1, 1, 16, 16);
            this.boldButton.setPosAndSize(27, 1, 16, 16);
            this.italicButton.setPosAndSize(43, 1, 16, 16);
            this.underlineButton.setPosAndSize(59, 1, 16, 16);
            this.strikethroughButton.setPosAndSize(75, 1, 16, 16);
            this.colorButton.setPosAndSize(91, 1, 16, 16);
            this.resetButton.setPosAndSize(107, 1, 16, 16);
            this.pageBreakButton.setPosAndSize(133, 1, 16, 16);
            this.imageButton.setPosAndSize(149, 1, 16, 16);
            this.undoButton.setPosAndSize(175, 1, 16, 16);
            this.cancelButton.setPosAndSize(this.width - 17, 1, 16, 16);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_0.draw(graphics, x, y, w, h);
            theme.drawPanelBackground(graphics, x, y, w, h);
        }
    }

    private class TextBoxPanel
    extends Panel {
        public TextBoxPanel(Panel outerPanel) {
            super(outerPanel);
        }

        public void addWidgets() {
            this.add((Widget)MultilineTextEditorScreen.this.textBox);
        }

        public void alignWidgets() {
            MultilineTextEditorScreen.this.textBox.setWidth(this.width - 3);
            this.setScrollY(0.0);
            MultilineTextEditorScreen.this.textBox.seekCursor(Whence.ABSOLUTE, 0);
        }

        public boolean mousePressed(MouseButton button) {
            boolean res = super.mousePressed(button);
            MultilineTextEditorScreen.this.textBox.setFocused(this.isMouseOver());
            return res;
        }
    }

    private record HistoryElement(@NotNull String text, int cursorPos) {
    }

    private static class ToolbarButton
    extends SimpleTextButton {
        private final Runnable onClick;
        private final List<Component> tooltip = new ArrayList<Component>();
        private boolean visible = true;

        public ToolbarButton(Panel panel, Component txt, Icon icon, Runnable onClick) {
            super(panel, txt, icon);
            this.onClick = onClick;
        }

        public ToolbarButton(Panel panel, Component txt, Runnable onClick) {
            this(panel, txt, (Icon)Color4I.empty(), onClick);
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public void onClicked(MouseButton button) {
            if (this.visible) {
                this.onClick.run();
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.getGui().getTheme().getStringWidth((FormattedText)this.title) > 0) {
                super.addMouseOverText(list);
            }
            if (this.visible) {
                this.tooltip.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            if (this.visible) {
                super.draw(graphics, theme, x, y, w, h);
            }
        }

        public ToolbarButton withTooltip(Component ... lines) {
            this.tooltip.addAll(Arrays.asList(lines));
            return this;
        }
    }
}

