/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.util.EmptyContainer;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class TableRecipeStorage {
    private final BaseItemStackHandler[] recipes = new BaseItemStackHandler[3];
    private final int slots;
    private int selected = -1;
    private BaseItemStackHandler selectedRecipeGrid = null;

    public TableRecipeStorage(int slots) {
        this.slots = slots;
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = BaseItemStackHandler.create((int)slots);
        }
    }

    public int getSlots() {
        return this.slots;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        if (selected == this.selected || selected < -1 || selected > 2) {
            selected = -1;
        }
        this.selected = selected;
        this.updateSelectedRecipeGrid();
    }

    public BaseItemStackHandler getRecipe(int index) {
        if (index < 0 || index >= this.recipes.length) {
            return null;
        }
        return this.recipes[index];
    }

    public boolean hasRecipe(int index) {
        if (index < 0 || index >= this.recipes.length) {
            return false;
        }
        return !this.recipes[index].getStacks().stream().allMatch(ItemStack::m_41619_);
    }

    public boolean hasRecipes() {
        return IntStream.range(0, this.recipes.length).anyMatch(this::hasRecipe);
    }

    public void setRecipe(int index, BaseItemStackHandler inventory, ItemStack output) {
        BaseItemStackHandler recipe = BaseItemStackHandler.create((int)this.slots);
        for (int i = 0; i < this.slots - 1; ++i) {
            recipe.setStackInSlot(i, inventory.getStackInSlot(i));
        }
        recipe.setStackInSlot(this.slots - 1, output);
        this.recipes[index] = recipe;
    }

    public void unsetRecipe(int index) {
        if (index < 0 || index >= this.recipes.length) {
            return;
        }
        this.recipes[index] = BaseItemStackHandler.create((int)this.slots);
        if (index == this.selected) {
            this.setSelected(-1);
        }
    }

    public BaseItemStackHandler[] getRecipes() {
        return this.recipes;
    }

    public int getRecipeCount() {
        return Arrays.stream(this.recipes).mapToInt(recipe -> recipe.getStacks().stream().allMatch(ItemStack::m_41619_) ? 0 : 1).sum();
    }

    public BaseItemStackHandler getSelectedRecipe() {
        if (this.selected < 0 || this.selected > this.recipes.length) {
            return null;
        }
        return this.recipes[this.selected];
    }

    public BaseItemStackHandler getSelectedRecipeGrid() {
        return this.selectedRecipeGrid;
    }

    public CompoundTag serializeNBT() {
        ListTag recipes = new ListTag();
        for (int i = 0; i < this.recipes.length; ++i) {
            recipes.add(i, (Tag)this.recipes[i].serializeNBT());
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Recipes", (Tag)recipes);
        tag.m_128405_("Selected", this.selected);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag recipes = tag.m_128437_("Recipes", 10);
        for (int i = 0; i < recipes.size(); ++i) {
            this.recipes[i].deserializeNBT(recipes.m_128728_(i));
        }
        this.selected = tag.m_128451_("Selected");
        this.updateSelectedRecipeGrid();
    }

    public void onLoad(Level level, RecipeType<? extends Recipe<Container>> type) {
        for (int i = 0; i < this.recipes.length; ++i) {
            if (!this.hasRecipe(i)) continue;
            BaseItemStackHandler recipe = this.recipes[i];
            BaseItemStackHandler grid = this.createRecipeGrid(recipe);
            ExtendedCraftingInventory inventory = new ExtendedCraftingInventory(EmptyContainer.INSTANCE, grid, 3);
            ItemStack result = level.m_7465_().m_44015_(type, (Container)inventory, level).map(r -> r.m_5874_((Container)inventory, level.m_9598_())).orElse(ItemStack.f_41583_);
            recipe.setStackInSlot(this.slots - 1, result);
        }
    }

    private void updateSelectedRecipeGrid() {
        if (this.selected > -1) {
            BaseItemStackHandler recipe = this.recipes[this.selected];
            this.selectedRecipeGrid = this.createRecipeGrid(recipe);
        } else {
            this.selectedRecipeGrid = null;
        }
    }

    private BaseItemStackHandler createRecipeGrid(BaseItemStackHandler recipe) {
        BaseItemStackHandler grid = BaseItemStackHandler.create((int)(this.slots - 1));
        for (int i = 0; i < this.slots - 1; ++i) {
            grid.setStackInSlot(i, recipe.getStackInSlot(i));
        }
        return grid;
    }
}

