/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.TableCrafting")
@ZenRegister
public final class TableCrafting
implements IRecipeManager<ITableRecipe> {
    private static final TableCrafting INSTANCE = new TableCrafting();

    public RecipeType<ITableRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.TABLE.get();
    }

    @ZenCodeType.Method
    public static void addShaped(String name, IItemStack output, IIngredient[][] inputs) {
        TableCrafting.addShaped(name, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShaped(String name, int tier, IItemStack output, IIngredient[][] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        if (tier > 4 || tier < 0) {
            tier = 0;
            CraftTweakerAPI.getLogger((String)"extendedcrafting").error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
        HashMap<Integer, Function<ItemStack, ItemStack>> transformers = new HashMap<Integer, Function<ItemStack, ItemStack>>();
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < inputs[a].length; ++b) {
                IIngredient iing = inputs[a][b];
                Ingredient ing = iing.asVanillaIngredient();
                int i = a * width + b;
                ingredients.set(i, (Object)ing);
                if (ing == Ingredient.f_43901_) continue;
                transformers.put(i, stack -> {
                    IItemStack istack = iing.getRemainingItem((IItemStack)new MCItemStack(stack));
                    return istack.getInternal();
                });
            }
        }
        ShapedTableRecipe recipe = new ShapedTableRecipe(id, width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), tier);
        recipe.setTransformers(transformers);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, IItemStack output, IIngredient[] inputs) {
        TableCrafting.addShapeless(name, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, int tier, IItemStack output, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        if (tier > 4 || tier < 0) {
            tier = 0;
            CraftTweakerAPI.getLogger((String)"extendedcrafting").error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        HashMap<Integer, Function<ItemStack, ItemStack>> transformers = new HashMap<Integer, Function<ItemStack, ItemStack>>();
        for (int i = 0; i < inputs.length; ++i) {
            IIngredient iing = inputs[i];
            Ingredient ing = iing.asVanillaIngredient();
            if (ing == Ingredient.f_43901_) continue;
            transformers.put(i, stack -> {
                IItemStack istack = iing.getRemainingItem((IItemStack)new MCItemStack(stack));
                return istack.getInternal();
            });
        }
        ShapelessTableRecipe recipe = new ShapelessTableRecipe(id, TableCrafting.toIngredientsList(inputs), output.getInternal(), tier);
        recipe.setTransformers(transformers);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(stack.getInternal().m_41720_())));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

