/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class CraftingCoreScreen
extends BaseContainerScreen<CraftingCoreContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/crafting_core.png");
    private CraftingCoreTileEntity tile;

    public CraftingCoreScreen(CraftingCoreContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.m_142416_((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        boolean isHoldingItem;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_88315_(gfx, mouseX, mouseY, partialTicks);
        boolean bl = isHoldingItem = !((CraftingCoreContainer)this.f_97732_).m_142621_().m_41619_() || this.m_7282_();
        if (!isHoldingItem && CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
            ItemStack output = this.getRecipeOutput();
            gfx.m_280153_(this.f_96547_, output, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        gfx.m_280056_(this.f_96547_, title, this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2, 6, 0x404040, false);
        gfx.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, 0x404040, false);
        PoseStack matrix = gfx.m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(0.75f, 0.75f, 0.75f);
        gfx.m_280488_(this.f_96547_, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.pedestals", (Object[])new Object[]{this.getPedestalCount()}), 36, 36, -1);
        if (!this.hasRecipe()) {
            gfx.m_280488_(this.f_96547_, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_recipe", (Object[])new Object[0]), 36, 56, -1);
        } else {
            gfx.m_280488_(this.f_96547_, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_cost", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRequired())}) + " FE", 36, 56, -1);
            gfx.m_280488_(this.f_96547_, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_rate", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRate())}) + " FE/t", 36, 66, -1);
            if (this.getEnergyStored() < this.getEnergyRate()) {
                gfx.m_280488_(this.f_96547_, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_power", (Object[])new Object[0]), 36, 86, -1);
            }
        }
        matrix.m_85849_();
    }

    protected void m_7286_(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.renderDefaultBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            if (this.getProgress() > 0 && this.getEnergyRate() > 0) {
                int i2 = this.getProgressBarScaled();
                gfx.m_280218_(BACKGROUND, x + 116, y + 47, 194, 0, i2 + 1, 16);
            }
            ItemStack output = this.getRecipeOutput();
            gfx.m_280480_(output, x + 148, y + 47);
            if (CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
                CraftingCoreScreen.m_280359_((GuiGraphics)gfx, (int)(x + 148), (int)(y + 47), (int)100);
            }
        }
    }

    private CraftingCoreTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((CraftingCoreContainer)this.m_6262_()).getBlockPos())) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            return core;
        }
        return null;
    }

    private boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    private ItemStack getRecipeOutput() {
        if (this.tile == null) {
            return ItemStack.f_41583_;
        }
        Level level = this.tile.m_58904_();
        if (level == null) {
            return ItemStack.f_41583_;
        }
        CombinationRecipe recipe = this.tile.getActiveRecipe();
        if (recipe != null) {
            return recipe.m_8043_(level.m_9598_());
        }
        return ItemStack.f_41583_;
    }

    private int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    private int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    private int getEnergyRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRequired();
    }

    private int getEnergyRate() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRate();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getPedestalCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getPedestalCount();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        long j = this.getEnergyRequired();
        return (int)(j != 0L && i != 0 ? (long)i * 24L / j : 0L);
    }

    private static boolean isHoveringSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX > x - 1 && mouseX < x + 16 && mouseY > y - 1 && mouseY < y + 16;
    }
}

