/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.world.entity.item;

import fuzs.bettertridents.handler.LoyalDropsHandler;
import fuzs.bettertridents.init.ModRegistry;
import fuzs.bettertridents.mixin.accessor.ExperienceOrbAccessor;
import fuzs.bettertridents.world.entity.item.LoyalItemEntity;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LoyalExperienceOrb
extends ExperienceOrb {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(LoyalItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private UUID owner;

    public LoyalExperienceOrb(Level level, double pX, double pY, double pZ, int pValue, UUID owner, int loyaltyLevel) {
        super((EntityType)ModRegistry.LOYAL_EXPERIENCE_ORB_ENTITY_TYPE.get(), level);
        this.m_6034_(pX, pY, pZ);
        this.m_146922_((float)(this.f_19796_.m_188500_() * 360.0));
        this.m_20334_((this.f_19796_.m_188500_() * (double)0.2f - (double)0.1f) * 2.0, this.f_19796_.m_188500_() * 0.2 * 2.0, (this.f_19796_.m_188500_() * (double)0.2f - (double)0.1f) * 2.0);
        ((ExperienceOrbAccessor)((Object)this)).setValue(pValue);
        this.owner = owner;
        if (loyaltyLevel < 1) {
            throw new IllegalStateException("Loyalty level missing from loyal item entity, was %s".formatted(loyaltyLevel));
        }
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)loyaltyLevel));
    }

    public LoyalExperienceOrb(EntityType<? extends ExperienceOrb> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
    }

    public void m_8119_() {
        Player player = this.owner != null ? LoyalDropsHandler.isAcceptableReturnOwner(this.m_9236_(), (Entity)this.m_9236_().m_46003_(this.owner)) : null;
        if (player != null) {
            LoyalDropsHandler.tickLoyalEntity((Entity)this, player, ((Byte)this.f_19804_.m_135370_(ID_LOYALTY)).byteValue());
            ((ExperienceOrbAccessor)((Object)this)).setAge(((ExperienceOrbAccessor)((Object)this)).getAge() + 1);
            if (((ExperienceOrbAccessor)((Object)this)).getAge() >= 6000) {
                this.m_146870_();
            }
        } else if (!this.m_9236_().f_46443_) {
            super.m_8119_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.owner != null) {
            compound.m_128362_("Owner", this.owner);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            this.owner = compound.m_128342_("Owner");
        }
    }
}

