/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.SingleNoteClientPacket;
import xerca.xercamusic.common.packets.SingleNotePacket;

public class SingleNotePacketHandler {
    public static void handle(SingleNotePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when MusicUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> SingleNotePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(SingleNotePacket msg, ServerPlayer pl) {
        PacketDistributor.PacketTarget target = PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pl.m_20185_(), pl.m_20186_(), pl.m_20189_(), 24.0, pl.m_9236_().m_46472_()));
        SingleNoteClientPacket packet = new SingleNoteClientPacket(msg.getNote(), msg.getInstrumentItem(), (Player)pl, msg.isStop(), msg.getVolume());
        XercaMusic.NETWORK_HANDLER.send(target, (Object)packet);
    }
}

