/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xerca.xercamusic.common.NoteEvent;

public class ImportMusicSendPacket {
    private UUID uuid;
    private CompoundTag tag;
    private ArrayList<NoteEvent> notes;
    private boolean messageIsValid;

    public ImportMusicSendPacket(CompoundTag tag) throws NotesTooLargeException {
        this.tag = tag;
        if (this.tag.m_128441_("id")) {
            this.uuid = tag.m_128342_("id");
        }
        if (this.tag.m_128441_("notes")) {
            this.notes = new ArrayList();
            NoteEvent.fillArrayFromNBT(this.notes, this.tag);
            this.tag.m_128473_("notes");
            if (this.notes.size() > 5000) {
                throw new NotesTooLargeException(this.notes, this.uuid);
            }
        }
    }

    public ImportMusicSendPacket() {
        this.messageIsValid = false;
    }

    public static void encode(ImportMusicSendPacket pkt, FriendlyByteBuf buf) {
        if (pkt.notes != null) {
            buf.writeInt(pkt.notes.size());
            for (NoteEvent event : pkt.notes) {
                event.encodeToBuffer(buf);
            }
        } else {
            buf.writeInt(0);
        }
        buf.m_130079_(pkt.tag);
    }

    public static ImportMusicSendPacket decode(FriendlyByteBuf buf) {
        ImportMusicSendPacket result = new ImportMusicSendPacket();
        try {
            int eventCount = buf.readInt();
            if (eventCount > 0) {
                result.notes = new ArrayList(eventCount);
                for (int i = 0; i < eventCount; ++i) {
                    result.notes.add(NoteEvent.fromBuffer(buf));
                }
            }
            result.tag = buf.m_130260_();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading ImportMusicSendPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public ArrayList<NoteEvent> getNotes() {
        return this.notes;
    }

    public void deleteNotes() {
        this.notes = null;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static class NotesTooLargeException
    extends Exception {
        public ArrayList<NoteEvent> notes;
        public UUID id;

        public NotesTooLargeException(ArrayList<NoteEvent> notes, UUID id) {
            this.notes = notes;
            this.id = id;
        }
    }
}

