/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xerca.xercamusic.common.entity.EntityMusicSpirit;

public interface IItemInstrument {
    public static final int minNote = 21;
    public static final int maxNote = 117;
    public static final int totalNotes = 96;

    public int getMinOctave();

    public int getMaxOctave();

    public int getInstrumentId();

    public void setSounds(ArrayList<Pair<Integer, SoundEvent>> var1);

    public InsSound getSound(int var1);

    public static int idToNote(int id) {
        return id + 21;
    }

    public static int noteToId(int note) {
        return note - 21;
    }

    public static void playMusic(Level worldIn, Player playerIn, boolean canStop) {
        List musicSpirits = worldIn.m_6443_(EntityMusicSpirit.class, playerIn.m_20191_().m_82400_(3.0), entity -> entity.getBody().m_7306_((Entity)playerIn));
        if (musicSpirits.size() == 0) {
            worldIn.m_7967_((Entity)new EntityMusicSpirit(worldIn, playerIn, (IItemInstrument)playerIn.m_21205_().m_41720_()));
        } else if (canStop) {
            musicSpirits.forEach(spirit -> spirit.setPlaying(false));
        }
    }

    public record Pair<F, S>(F first, S second) {
        public static <F, S> Pair<F, S> of(F first, S second) {
            if (first == null || second == null) {
                throw new IllegalArgumentException("Pair.of requires non null values.");
            }
            return new Pair<F, S>(first, second);
        }

        @Override
        public int hashCode() {
            return this.first.hashCode() * 37 + this.second.hashCode();
        }
    }

    public static class InsSound {
        public final SoundEvent sound;
        public final float pitch;

        public InsSound(SoundEvent sound, float pitch) {
            this.sound = sound;
            this.pitch = pitch;
        }
    }
}

