/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.entity;

import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.SoundController;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockInstrument;
import xerca.xercamusic.common.entity.Entities;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EntityMusicSpirit
extends Entity
implements IEntityAdditionalSpawnData {
    private Player body;
    private ItemStack note;
    private IItemInstrument instrument;
    private final ArrayList<NoteEvent> notes = new ArrayList();
    private int mLengthBeats;
    private float mVolume;
    private byte mBPS;
    private boolean isPlaying = true;
    private BlockInstrument blockInstrument = null;
    private BlockPos blockInsPos = null;
    private SoundController soundController = null;

    public EntityMusicSpirit(Level worldIn) {
        super((EntityType)Entities.MUSIC_SPIRIT.get(), worldIn);
    }

    public EntityMusicSpirit(Level worldIn, Player body, IItemInstrument instrument) {
        super((EntityType)Entities.MUSIC_SPIRIT.get(), worldIn);
        this.body = body;
        this.instrument = instrument;
        this.setNoteFromBody();
        this.m_6034_(body.m_20185_(), body.m_20186_(), body.m_20189_());
    }

    public EntityMusicSpirit(Level worldIn, Player body, BlockPos blockInsPos, IItemInstrument instrument) {
        this(worldIn, body, instrument);
        this.setBlockPosAndInstrument(blockInsPos);
    }

    public EntityMusicSpirit(EntityType<EntityMusicSpirit> type, Level world) {
        super(type, world);
    }

    public EntityMusicSpirit(PlayMessages.SpawnEntity ignoredSpawnEntity, Level world) {
        this(world);
    }

    private void setBlockPosAndInstrument(BlockPos pos) {
        this.blockInsPos = pos;
        Block block = this.m_9236_().m_8055_(this.blockInsPos).m_60734_();
        if (block instanceof BlockInstrument) {
            this.blockInstrument = (BlockInstrument)block;
            this.m_6034_((double)this.blockInsPos.m_123341_() + 0.5, (double)this.blockInsPos.m_123342_() - 0.5, (double)this.blockInsPos.m_123343_() + 0.5);
        } else {
            XercaMusic.LOGGER.warn("Got invalid block as instrument");
            this.blockInstrument = null;
            this.blockInsPos = null;
        }
    }

    private boolean isBodyHandLegit() {
        ItemStack mainStack = this.body.m_21205_();
        ItemStack offStack = this.body.m_21206_();
        if (this.blockInstrument != null && this.blockInsPos != null) {
            return mainStack.m_41720_() == Items.MUSIC_SHEET.get() || offStack.m_41720_() == Items.MUSIC_SHEET.get();
        }
        return offStack.m_41720_() == Items.MUSIC_SHEET.get() && mainStack.m_41720_() == this.instrument;
    }

    private void setNoteFromBody() {
        ItemStack mainStack = this.body.m_21205_();
        ItemStack offStack = this.body.m_21206_();
        if (mainStack.m_41720_() == Items.MUSIC_SHEET.get()) {
            this.note = mainStack;
        } else if (offStack.m_41720_() == Items.MUSIC_SHEET.get()) {
            this.note = offStack;
        } else {
            XercaMusic.LOGGER.warn("No music sheet found on body");
        }
    }

    protected void m_7378_(CompoundTag tag) {
        NoteEvent.fillArrayFromNBT(this.notes, tag);
        this.mLengthBeats = tag.m_128451_("l");
        this.mBPS = tag.m_128445_("bps");
        this.mVolume = tag.m_128457_("vol");
        this.isPlaying = tag.m_128471_("playing");
        if (tag.m_128441_("bX") && tag.m_128441_("bY") && tag.m_128441_("bZ")) {
            this.setBlockPosAndInstrument(new BlockPos(tag.m_128451_("bX"), tag.m_128451_("bY"), tag.m_128451_("bZ")));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        NoteEvent.fillNBTFromArray(this.notes, tag);
        tag.m_128405_("l", this.mLengthBeats);
        tag.m_128344_("bps", this.mBPS);
        tag.m_128350_("vol", this.mVolume);
        tag.m_128379_("playing", this.isPlaying);
        if (this.blockInstrument != null && this.blockInsPos != null) {
            tag.m_128405_("bX", this.blockInsPos.m_123341_());
            tag.m_128405_("bY", this.blockInsPos.m_123342_());
            tag.m_128405_("bZ", this.blockInsPos.m_123343_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.body != null ? this.body.m_19879_() : -1);
        if (this.blockInstrument != null && this.blockInsPos != null) {
            buffer.writeInt(this.blockInsPos.m_123341_());
            buffer.writeInt(this.blockInsPos.m_123342_());
            buffer.writeInt(this.blockInsPos.m_123343_());
        } else {
            buffer.writeInt(-1);
            buffer.writeInt(-1000);
            buffer.writeInt(-1);
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        Entity ent = this.m_9236_().m_6815_(entityId);
        if (ent instanceof Player) {
            this.body = (Player)ent;
        }
        int bx = buffer.readInt();
        int by = buffer.readInt();
        int bz = buffer.readInt();
        if (by > -1000) {
            this.setBlockPosAndInstrument(new BlockPos(bx, by, bz));
        }
        if (this.blockInsPos != null) {
            this.instrument = this.blockInstrument.getItemInstrument();
            this.setNoteFromBody();
        } else {
            this.instrument = (IItemInstrument)this.body.m_21205_().m_41720_();
            this.note = this.body.m_21206_();
            this.m_6034_(this.body.m_20185_(), this.body.m_20186_(), this.body.m_20189_());
        }
        if (this.note.m_41782_() && this.note.m_41783_() != null && this.note.m_41783_().m_128441_("id") && this.note.m_41783_().m_128441_("ver") && this.note.m_41783_().m_128441_("l")) {
            CompoundTag comp = this.note.m_41783_();
            this.mLengthBeats = comp.m_128451_("l");
            this.mBPS = (byte)(comp.m_128441_("bps") ? (int)comp.m_128445_("bps") : 8);
            this.mVolume = comp.m_128441_("vol") ? comp.m_128457_("vol") : 1.0f;
            UUID id = comp.m_128342_("id");
            int ver = comp.m_128451_("ver");
            if (this.m_9236_().f_46443_) {
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        this.notes.addAll(data.notes);
                    }
                    this.soundController = new SoundController(this.notes, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.instrument, this.mBPS, this.mVolume, this.m_19879_());
                    this.soundController.start();
                });
            }
        }
    }

    protected void m_8097_() {
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.soundController != null) {
            this.soundController.setStop();
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.body == null || !this.isPlaying) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (!this.isBodyHandLegit()) {
                this.isPlaying = false;
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (this.blockInsPos != null && this.blockInstrument != null) {
                if (this.m_9236_().m_8055_(this.blockInsPos).m_60734_() != this.blockInstrument) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                if (this.m_20182_().m_82557_(this.body.m_20182_()) > 16.0) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
        }
        super.m_8119_();
        if ((this.blockInsPos == null || this.blockInstrument == null) && this.body != null) {
            this.m_6034_(this.body.m_20185_(), this.body.m_20186_(), this.body.m_20189_());
            if (this.soundController != null) {
                this.soundController.setPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        }
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public Player getBody() {
        return this.body;
    }
}

