/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.tile_entity.TileEntityMetronome;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockMetronome
extends BaseEntityBlock {
    public static final IntegerProperty BPS = IntegerProperty.m_61631_((String)"bps", (int)1, (int)50);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public BlockMetronome() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BPS, (Comparable)Integer.valueOf(6))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.m_276867_(pos);
        if (flag != (Boolean)state.m_61143_((Property)POWERED)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void setBps(BlockState state, Level worldIn, BlockPos pos, int bps) {
        if (!worldIn.f_46443_ && bps >= 1 && bps <= 50) {
            state = (BlockState)state.m_61124_((Property)BPS, (Comparable)Integer.valueOf(bps));
            worldIn.m_7731_(pos, state, 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            if (SoundEvents.METRONOME_SET != null) {
                worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.METRONOME_SET, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack note = ItemStack.f_41583_;
            if (player.m_21120_(hand).m_41720_() == Items.MUSIC_SHEET.get()) {
                note = player.m_21120_(hand);
            } else if (player.m_21206_().m_41720_() == Items.MUSIC_SHEET.get()) {
                note = player.m_21206_();
            }
            if (!note.m_41619_() && note.m_41783_() != null && note.m_41783_().m_128441_("bps")) {
                int bps = note.m_41783_().m_128451_("bps");
                this.setBps(state, worldIn, pos, bps);
            } else {
                state = (BlockState)state.m_61122_((Property)BPS);
                worldIn.m_7731_(pos, state, 3);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BPS, POWERED, FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityMetronome(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState1, t) -> {
            if (t instanceof TileEntityMetronome) {
                TileEntityMetronome.tick(level1, blockPos, blockState1, (TileEntityMetronome)t);
            }
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

