/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegisterEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.Items;

public class SoundEvents {
    @ObjectHolder(registryName="minecraft:sound_event", value="xercamusic:tick")
    public static final SoundEvent TICK = (SoundEvent)XercaMusic.Null();
    @ObjectHolder(registryName="minecraft:sound_event", value="xercamusic:metronome_set")
    public static final SoundEvent METRONOME_SET = (SoundEvent)XercaMusic.Null();
    @ObjectHolder(registryName="minecraft:sound_event", value="xercamusic:open_scroll")
    public static final SoundEvent OPEN_SCROLL = (SoundEvent)XercaMusic.Null();
    @ObjectHolder(registryName="minecraft:sound_event", value="xercamusic:close_scroll")
    public static final SoundEvent CLOSE_SCROLL = (SoundEvent)XercaMusic.Null();
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> cymbals;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> drum_kits;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> guitars;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> lyres;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> drums;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> flutes;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> banjos;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> saxophones;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> gods;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> harp_mcs;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> sansulas;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> tubular_bells;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> violins;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> xylophones;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> cellos;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> pianos;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> oboes;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> redstone_guitars;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> french_horns;
    public static ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> bass_guitars;

    private static SoundEvent createSoundEvent(String soundName, RegisterEvent event) {
        ResourceLocation soundID = new ResourceLocation("xercamusic", soundName);
        SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundID);
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, soundID, () -> soundEvent);
        return soundEvent;
    }

    private static void addSound(ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> array, String insName, int note, RegisterEvent event) {
        array.add(IItemInstrument.Pair.of(note, SoundEvents.createSoundEvent(insName + note, event)));
    }

    public static void setup() {
        ((IItemInstrument)Items.CYMBAL.get()).setSounds(cymbals);
        ((IItemInstrument)Items.DRUM_KIT.get()).setSounds(drum_kits);
        ((IItemInstrument)Items.GUITAR.get()).setSounds(guitars);
        ((IItemInstrument)Items.LYRE.get()).setSounds(lyres);
        ((IItemInstrument)Items.DRUM.get()).setSounds(drums);
        ((IItemInstrument)Items.FLUTE.get()).setSounds(flutes);
        ((IItemInstrument)Items.BANJO.get()).setSounds(banjos);
        ((IItemInstrument)Items.SAXOPHONE.get()).setSounds(saxophones);
        ((IItemInstrument)Items.GOD.get()).setSounds(gods);
        ((IItemInstrument)Items.SANSULA.get()).setSounds(sansulas);
        ((IItemInstrument)Items.TUBULAR_BELL.get()).setSounds(tubular_bells);
        ((IItemInstrument)Items.VIOLIN.get()).setSounds(violins);
        ((IItemInstrument)Items.XYLOPHONE.get()).setSounds(xylophones);
        ((IItemInstrument)Items.CELLO.get()).setSounds(cellos);
        ((IItemInstrument)Items.PIANO.get()).setSounds(pianos);
        ((IItemInstrument)Items.OBOE.get()).setSounds(oboes);
        ((IItemInstrument)Items.REDSTONE_GUITAR.get()).setSounds(redstone_guitars);
        ((IItemInstrument)Items.FRENCH_HORN.get()).setSounds(french_horns);
        ((IItemInstrument)Items.BASS_GUITAR.get()).setSounds(bass_guitars);
        ((ItemInstrument)Items.HARP_MC.get()).setSounds(harp_mcs);
    }

    @Mod.EventBusSubscriber(modid="xercamusic", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerSoundEvents(RegisterEvent event) {
            int i;
            SoundEvents.createSoundEvent("tick", event);
            SoundEvents.createSoundEvent("metronome_set", event);
            SoundEvents.createSoundEvent("open_scroll", event);
            SoundEvents.createSoundEvent("close_scroll", event);
            cymbals = new ArrayList(48);
            drum_kits = new ArrayList(48);
            guitars = new ArrayList(48);
            drums = new ArrayList(48);
            lyres = new ArrayList(48);
            flutes = new ArrayList(48);
            banjos = new ArrayList(48);
            saxophones = new ArrayList(48);
            gods = new ArrayList(48);
            harp_mcs = new ArrayList(48);
            sansulas = new ArrayList(48);
            tubular_bells = new ArrayList(48);
            violins = new ArrayList(48);
            xylophones = new ArrayList(48);
            cellos = new ArrayList(48);
            pianos = new ArrayList(48);
            oboes = new ArrayList(21);
            redstone_guitars = new ArrayList(11);
            french_horns = new ArrayList(11);
            bass_guitars = new ArrayList(8);
            for (i = 21; i <= 116; ++i) {
                SoundEvents.addSound(drum_kits, "drum_kit", i, event);
            }
            for (i = 27; i <= 111; i += 6) {
                SoundEvents.addSound(harp_mcs, "harp_mc", i, event);
            }
            SoundEvents.addSound(guitars, "guitar", 24, event);
            SoundEvents.addSound(guitars, "guitar", 28, event);
            SoundEvents.addSound(guitars, "guitar", 34, event);
            SoundEvents.addSound(guitars, "guitar", 40, event);
            SoundEvents.addSound(guitars, "guitar", 48, event);
            SoundEvents.addSound(guitars, "guitar", 54, event);
            SoundEvents.addSound(guitars, "guitar", 55, event);
            SoundEvents.addSound(guitars, "guitar", 59, event);
            SoundEvents.addSound(guitars, "guitar", 65, event);
            SoundEvents.addSound(guitars, "guitar", 72, event);
            SoundEvents.addSound(guitars, "guitar", 78, event);
            SoundEvents.addSound(guitars, "guitar", 84, event);
            SoundEvents.addSound(guitars, "guitar", 90, event);
            SoundEvents.addSound(guitars, "guitar", 96, event);
            SoundEvents.addSound(guitars, "guitar", 102, event);
            SoundEvents.addSound(lyres, "lyre", 33, event);
            SoundEvents.addSound(lyres, "lyre", 39, event);
            SoundEvents.addSound(lyres, "lyre", 45, event);
            SoundEvents.addSound(lyres, "lyre", 51, event);
            SoundEvents.addSound(lyres, "lyre", 57, event);
            SoundEvents.addSound(lyres, "lyre", 63, event);
            SoundEvents.addSound(lyres, "lyre", 69, event);
            SoundEvents.addSound(lyres, "lyre", 75, event);
            SoundEvents.addSound(lyres, "lyre", 81, event);
            SoundEvents.addSound(lyres, "lyre", 87, event);
            SoundEvents.addSound(lyres, "lyre", 93, event);
            SoundEvents.addSound(gods, "god", 27, event);
            SoundEvents.addSound(gods, "god", 33, event);
            SoundEvents.addSound(gods, "god", 39, event);
            SoundEvents.addSound(gods, "god", 45, event);
            SoundEvents.addSound(gods, "god", 51, event);
            SoundEvents.addSound(gods, "god", 57, event);
            SoundEvents.addSound(gods, "god", 63, event);
            SoundEvents.addSound(gods, "god", 69, event);
            SoundEvents.addSound(gods, "god", 75, event);
            SoundEvents.addSound(gods, "god", 81, event);
            SoundEvents.addSound(gods, "god", 87, event);
            SoundEvents.addSound(banjos, "banjo", 27, event);
            SoundEvents.addSound(banjos, "banjo", 33, event);
            SoundEvents.addSound(banjos, "banjo", 39, event);
            SoundEvents.addSound(banjos, "banjo", 45, event);
            SoundEvents.addSound(banjos, "banjo", 51, event);
            SoundEvents.addSound(banjos, "banjo", 57, event);
            SoundEvents.addSound(banjos, "banjo", 63, event);
            SoundEvents.addSound(banjos, "banjo", 69, event);
            SoundEvents.addSound(banjos, "banjo", 75, event);
            SoundEvents.addSound(banjos, "banjo", 81, event);
            SoundEvents.addSound(drums, "drum", 33, event);
            SoundEvents.addSound(drums, "drum", 39, event);
            SoundEvents.addSound(drums, "drum", 43, event);
            SoundEvents.addSound(drums, "drum", 50, event);
            SoundEvents.addSound(drums, "drum", 55, event);
            SoundEvents.addSound(drums, "drum", 58, event);
            SoundEvents.addSound(drums, "drum", 63, event);
            SoundEvents.addSound(drums, "drum", 69, event);
            SoundEvents.addSound(drums, "drum", 75, event);
            SoundEvents.addSound(drums, "drum", 81, event);
            SoundEvents.addSound(cymbals, "cymbal", 27, event);
            SoundEvents.addSound(cymbals, "cymbal", 33, event);
            SoundEvents.addSound(cymbals, "cymbal", 39, event);
            SoundEvents.addSound(cymbals, "cymbal", 45, event);
            SoundEvents.addSound(cymbals, "cymbal", 51, event);
            SoundEvents.addSound(cymbals, "cymbal", 57, event);
            SoundEvents.addSound(cymbals, "cymbal", 63, event);
            SoundEvents.addSound(cymbals, "cymbal", 69, event);
            SoundEvents.addSound(cymbals, "cymbal", 75, event);
            SoundEvents.addSound(cymbals, "cymbal", 81, event);
            SoundEvents.addSound(xylophones, "xylophone", 27, event);
            SoundEvents.addSound(xylophones, "xylophone", 33, event);
            SoundEvents.addSound(xylophones, "xylophone", 39, event);
            SoundEvents.addSound(xylophones, "xylophone", 45, event);
            SoundEvents.addSound(xylophones, "xylophone", 51, event);
            SoundEvents.addSound(xylophones, "xylophone", 57, event);
            SoundEvents.addSound(xylophones, "xylophone", 63, event);
            SoundEvents.addSound(xylophones, "xylophone", 69, event);
            SoundEvents.addSound(xylophones, "xylophone", 75, event);
            SoundEvents.addSound(xylophones, "xylophone", 81, event);
            SoundEvents.addSound(xylophones, "xylophone", 87, event);
            SoundEvents.addSound(sansulas, "sansula", 33, event);
            SoundEvents.addSound(sansulas, "sansula", 39, event);
            SoundEvents.addSound(sansulas, "sansula", 45, event);
            SoundEvents.addSound(sansulas, "sansula", 51, event);
            SoundEvents.addSound(sansulas, "sansula", 57, event);
            SoundEvents.addSound(sansulas, "sansula", 63, event);
            SoundEvents.addSound(sansulas, "sansula", 69, event);
            SoundEvents.addSound(sansulas, "sansula", 75, event);
            SoundEvents.addSound(sansulas, "sansula", 81, event);
            SoundEvents.addSound(sansulas, "sansula", 87, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 33, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 39, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 45, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 51, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 57, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 63, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 69, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 75, event);
            SoundEvents.addSound(tubular_bells, "tubular_bell", 81, event);
            SoundEvents.addSound(cellos, "cello", 25, event);
            SoundEvents.addSound(cellos, "cello", 31, event);
            SoundEvents.addSound(cellos, "cello", 37, event);
            SoundEvents.addSound(cellos, "cello", 43, event);
            SoundEvents.addSound(cellos, "cello", 49, event);
            SoundEvents.addSound(cellos, "cello", 52, event);
            SoundEvents.addSound(cellos, "cello", 55, event);
            SoundEvents.addSound(cellos, "cello", 58, event);
            SoundEvents.addSound(cellos, "cello", 61, event);
            SoundEvents.addSound(cellos, "cello", 64, event);
            SoundEvents.addSound(cellos, "cello", 67, event);
            SoundEvents.addSound(cellos, "cello", 70, event);
            SoundEvents.addSound(cellos, "cello", 73, event);
            SoundEvents.addSound(cellos, "cello", 76, event);
            SoundEvents.addSound(cellos, "cello", 79, event);
            SoundEvents.addSound(cellos, "cello", 82, event);
            SoundEvents.addSound(cellos, "cello", 85, event);
            SoundEvents.addSound(cellos, "cello", 88, event);
            SoundEvents.addSound(cellos, "cello", 91, event);
            SoundEvents.addSound(cellos, "cello", 94, event);
            SoundEvents.addSound(cellos, "cello", 97, event);
            SoundEvents.addSound(cellos, "cello", 100, event);
            SoundEvents.addSound(violins, "violin", 37, event);
            SoundEvents.addSound(violins, "violin", 43, event);
            SoundEvents.addSound(violins, "violin", 49, event);
            SoundEvents.addSound(violins, "violin", 55, event);
            SoundEvents.addSound(violins, "violin", 58, event);
            SoundEvents.addSound(violins, "violin", 61, event);
            SoundEvents.addSound(violins, "violin", 64, event);
            SoundEvents.addSound(violins, "violin", 67, event);
            SoundEvents.addSound(violins, "violin", 70, event);
            SoundEvents.addSound(violins, "violin", 73, event);
            SoundEvents.addSound(violins, "violin", 76, event);
            SoundEvents.addSound(violins, "violin", 79, event);
            SoundEvents.addSound(violins, "violin", 82, event);
            SoundEvents.addSound(violins, "violin", 85, event);
            SoundEvents.addSound(violins, "violin", 88, event);
            SoundEvents.addSound(violins, "violin", 91, event);
            SoundEvents.addSound(flutes, "flute", 35, event);
            SoundEvents.addSound(flutes, "flute", 41, event);
            SoundEvents.addSound(flutes, "flute", 51, event);
            SoundEvents.addSound(flutes, "flute", 61, event);
            SoundEvents.addSound(flutes, "flute", 63, event);
            SoundEvents.addSound(flutes, "flute", 65, event);
            SoundEvents.addSound(flutes, "flute", 68, event);
            SoundEvents.addSound(flutes, "flute", 73, event);
            SoundEvents.addSound(flutes, "flute", 76, event);
            SoundEvents.addSound(flutes, "flute", 78, event);
            SoundEvents.addSound(flutes, "flute", 80, event);
            SoundEvents.addSound(flutes, "flute", 85, event);
            SoundEvents.addSound(flutes, "flute", 88, event);
            SoundEvents.addSound(flutes, "flute", 90, event);
            SoundEvents.addSound(flutes, "flute", 100, event);
            SoundEvents.addSound(saxophones, "saxophone", 24, event);
            SoundEvents.addSound(saxophones, "saxophone", 30, event);
            SoundEvents.addSound(saxophones, "saxophone", 36, event);
            SoundEvents.addSound(saxophones, "saxophone", 38, event);
            SoundEvents.addSound(saxophones, "saxophone", 41, event);
            SoundEvents.addSound(saxophones, "saxophone", 45, event);
            SoundEvents.addSound(saxophones, "saxophone", 48, event);
            SoundEvents.addSound(saxophones, "saxophone", 50, event);
            SoundEvents.addSound(saxophones, "saxophone", 53, event);
            SoundEvents.addSound(saxophones, "saxophone", 57, event);
            SoundEvents.addSound(saxophones, "saxophone", 60, event);
            SoundEvents.addSound(saxophones, "saxophone", 65, event);
            SoundEvents.addSound(saxophones, "saxophone", 72, event);
            SoundEvents.addSound(saxophones, "saxophone", 78, event);
            SoundEvents.addSound(pianos, "piano", 27, event);
            SoundEvents.addSound(pianos, "piano", 36, event);
            SoundEvents.addSound(pianos, "piano", 40, event);
            SoundEvents.addSound(pianos, "piano", 45, event);
            SoundEvents.addSound(pianos, "piano", 56, event);
            SoundEvents.addSound(pianos, "piano", 61, event);
            SoundEvents.addSound(pianos, "piano", 66, event);
            SoundEvents.addSound(pianos, "piano", 70, event);
            SoundEvents.addSound(pianos, "piano", 73, event);
            SoundEvents.addSound(pianos, "piano", 77, event);
            SoundEvents.addSound(pianos, "piano", 82, event);
            SoundEvents.addSound(pianos, "piano", 86, event);
            SoundEvents.addSound(pianos, "piano", 90, event);
            SoundEvents.addSound(pianos, "piano", 95, event);
            SoundEvents.addSound(pianos, "piano", 103, event);
            SoundEvents.addSound(pianos, "piano", 109, event);
            SoundEvents.addSound(oboes, "oboe", 23, event);
            SoundEvents.addSound(oboes, "oboe", 29, event);
            SoundEvents.addSound(oboes, "oboe", 35, event);
            SoundEvents.addSound(oboes, "oboe", 37, event);
            SoundEvents.addSound(oboes, "oboe", 39, event);
            SoundEvents.addSound(oboes, "oboe", 40, event);
            SoundEvents.addSound(oboes, "oboe", 42, event);
            SoundEvents.addSound(oboes, "oboe", 44, event);
            SoundEvents.addSound(oboes, "oboe", 46, event);
            SoundEvents.addSound(oboes, "oboe", 48, event);
            SoundEvents.addSound(oboes, "oboe", 50, event);
            SoundEvents.addSound(oboes, "oboe", 52, event);
            SoundEvents.addSound(oboes, "oboe", 54, event);
            SoundEvents.addSound(oboes, "oboe", 55, event);
            SoundEvents.addSound(oboes, "oboe", 57, event);
            SoundEvents.addSound(oboes, "oboe", 59, event);
            SoundEvents.addSound(oboes, "oboe", 60, event);
            SoundEvents.addSound(oboes, "oboe", 62, event);
            SoundEvents.addSound(oboes, "oboe", 64, event);
            SoundEvents.addSound(oboes, "oboe", 65, event);
            SoundEvents.addSound(oboes, "oboe", 71, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 27, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 33, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 39, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 45, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 51, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 57, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 63, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 69, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 75, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 81, event);
            SoundEvents.addSound(redstone_guitars, "redstone_guitar", 87, event);
            SoundEvents.addSound(french_horns, "french_horn", 27, event);
            SoundEvents.addSound(french_horns, "french_horn", 33, event);
            SoundEvents.addSound(french_horns, "french_horn", 39, event);
            SoundEvents.addSound(french_horns, "french_horn", 45, event);
            SoundEvents.addSound(french_horns, "french_horn", 51, event);
            SoundEvents.addSound(french_horns, "french_horn", 57, event);
            SoundEvents.addSound(french_horns, "french_horn", 63, event);
            SoundEvents.addSound(french_horns, "french_horn", 69, event);
            SoundEvents.addSound(french_horns, "french_horn", 75, event);
            SoundEvents.addSound(french_horns, "french_horn", 81, event);
            SoundEvents.addSound(french_horns, "french_horn", 87, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 33, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 39, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 45, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 51, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 57, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 63, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 69, event);
            SoundEvents.addSound(bass_guitars, "bass_guitar", 75, event);
        }
    }
}

