/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.client.MidiHandler;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockInstrument;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.packets.SingleNotePacket;

public class GuiInstrument
extends Screen {
    private static final ResourceLocation insGuiTextures = new ResourceLocation("xercamusic", "textures/gui/instrument_gui.png");
    private int guiBaseX = 45;
    private int guiBaseY = 80;
    private final boolean[] buttonPushStates;
    private final NoteSound[] noteSounds;
    private static int currentKeyboardOctave = 0;
    private static final int guiHeight = 201;
    private static final int guiWidth = 401;
    private static final int guiMarginWidth = 7;
    private static final int guiNoteWidth = 8;
    private static final int guiOctaveWidth = 97;
    private static final int guiOctaveHighlightY = 212;
    private static final int guiOctaveHighlightWidth = 98;
    private static final int guiOctaveHighlightHeight = 92;
    private static final int guiTopKeyboardBottom = 94;
    private static final int guiBottomKeyboardTop = 105;
    private static final int guiOctaveBlockX = 99;
    private static final int guiOctaveBlockY = 212;
    private static final int guiOctaveBlockWidth = 95;
    private static final int guiOctaveBlockHeight = 82;
    private int octaveButtonX;
    private final int octaveButtonY = 30;
    private final Player player;
    private final IItemInstrument instrument;
    private final BlockPos blockInsPos;
    private final MidiHandler midiHandler;

    GuiInstrument(Player player, IItemInstrument instrument, Component title, @Nullable BlockPos blockInsPos) {
        super(title);
        this.player = player;
        this.instrument = instrument;
        this.buttonPushStates = new boolean[96];
        this.noteSounds = new NoteSound[96];
        this.midiHandler = new MidiHandler(this::playSound, this::stopSound);
        this.blockInsPos = blockInsPos;
        if (currentKeyboardOctave < instrument.getMinOctave()) {
            currentKeyboardOctave = instrument.getMinOctave();
        } else if (currentKeyboardOctave > instrument.getMaxOctave()) {
            currentKeyboardOctave = instrument.getMaxOctave();
        }
        this.midiHandler.currentOctave = currentKeyboardOctave;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        this.guiBaseX = (this.f_96543_ - 401) / 2;
        this.guiBaseY = (this.f_96544_ - 201) / 2;
        this.octaveButtonX = this.guiBaseX - 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"note.upButton"), button -> this.increaseOctave()).m_252987_(this.octaveButtonX, 30, 10, 10).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ins.octaveTooltip"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"note.downButton"), button -> this.decreaseOctave()).m_252987_(this.octaveButtonX, 55, 10, 10).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ins.octaveTooltip"))).m_253136_());
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.blockInsPos != null && this.f_96541_ != null) {
            Block block = this.player.m_9236_().m_8055_(this.blockInsPos).m_60734_();
            if (block instanceof BlockInstrument) {
                BlockInstrument blockIns = (BlockInstrument)block;
                if (blockIns.getItemInstrument() != this.instrument) {
                    this.f_96541_.m_91152_(null);
                }
            } else {
                this.f_96541_.m_91152_(null);
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)insGuiTextures);
        guiGraphics.m_280398_(insGuiTextures, this.guiBaseX, this.guiBaseY, 0, 0.0f, 0.0f, 401, 201, 512, 512);
        for (int i = 0; i < this.buttonPushStates.length; ++i) {
            if (!this.buttonPushStates[i]) continue;
            int pushedOctave = i / 12;
            int x = this.guiBaseX + 7 + i * 8 + pushedOctave;
            int y = this.guiBaseY + 11;
            if (pushedOctave > 3) {
                x -= 388;
                y = this.guiBaseY + 105 + 2;
            }
            guiGraphics.m_280398_(insGuiTextures, x, y, 0, 402.0f, 11.0f, 7, 82, 512, 512);
        }
        int currentKeyboardOctaveDraw = Math.max(0, currentKeyboardOctave);
        int octaveHighlightX = this.guiBaseX + 7 + currentKeyboardOctaveDraw * 97 - 1;
        int octaveHighlightY = this.guiBaseY + 3;
        if (currentKeyboardOctave > 3) {
            octaveHighlightX -= 388;
            octaveHighlightY = this.guiBaseY + 105 - 6;
        }
        guiGraphics.m_280411_(insGuiTextures, octaveHighlightX, octaveHighlightY, 0, 0, 0.0f, 212.0f, 98, 92, 512, 512);
        for (int i = 0; i < 8; ++i) {
            if (i >= this.instrument.getMinOctave() && i <= this.instrument.getMaxOctave()) continue;
            int x = this.guiBaseX + 7 + i * 97;
            int y = this.guiBaseY + 11;
            if (i > 3) {
                x -= 388;
                y = this.guiBaseY + 105 + 2;
            }
            guiGraphics.m_280411_(insGuiTextures, x, y, 0, 0, 99.0f, 212.0f, 95, 82, 512, 512);
        }
        guiGraphics.m_280137_(this.f_96547_, "" + currentKeyboardOctave, this.octaveButtonX + 4, 44, -1);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private int noteIdFromPos(int mouseX, int mouseY) {
        int buttonBaseX = this.guiBaseX + 7;
        if (mouseX >= buttonBaseX && mouseX <= buttonBaseX + 401 - 14 && mouseY >= this.guiBaseY + 9 && mouseY <= this.guiBaseY + 201 - 10 && (mouseY < this.guiBaseY + 94 || mouseY > this.guiBaseY + 105)) {
            int octavePlus = mouseY < this.guiBaseY + 94 ? 0 : 4;
            int octave = octavePlus + (mouseX - buttonBaseX) / 97;
            int note = (mouseX - buttonBaseX) % 97 / 8;
            if (note < 12) {
                return octave * 12 + note;
            }
        }
        return -1;
    }

    private void playSound(int noteId) {
        this.playSound(new MidiHandler.MidiData(noteId, 0.8f));
    }

    private void playSound(MidiHandler.MidiData data) {
        int noteId = data.noteId();
        if (noteId >= 0 && noteId < this.buttonPushStates.length && !this.buttonPushStates[noteId]) {
            int note = IItemInstrument.idToNote(noteId);
            IItemInstrument.InsSound noteSound = this.instrument.getSound(note);
            if (noteSound == null) {
                return;
            }
            this.noteSounds[noteId] = (NoteSound)((Object)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(noteSound.sound, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), data.volume(), noteSound.pitch)));
            this.player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.player.m_20185_(), this.player.m_20186_() + 2.2, this.player.m_20189_(), (double)note / 24.0, 0.0, 0.0);
            this.buttonPushStates[noteId] = true;
            SingleNotePacket pack = new SingleNotePacket(note, this.instrument, false, data.volume());
            XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack);
        }
    }

    private void stopSound(int noteId) {
        if (noteId >= 0 && noteId < this.buttonPushStates.length && this.buttonPushStates[noteId] && this.noteSounds[noteId] != null) {
            this.noteSounds[noteId].stopSound();
            this.noteSounds[noteId] = null;
            this.buttonPushStates[noteId] = false;
            int note = IItemInstrument.idToNote(noteId);
            SingleNotePacket pack = new SingleNotePacket(note, this.instrument, true);
            XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack);
        }
    }

    private void stopAllSounds() {
        for (int noteId = 0; noteId < this.buttonPushStates.length; ++noteId) {
            this.stopSound(noteId);
        }
    }

    public boolean m_6375_(double dmouseX, double dmouseY, int mouseButton) {
        int mouseX = (int)Math.round(dmouseX);
        int mouseY = (int)Math.round(dmouseY);
        int noteId = this.noteIdFromPos(mouseX, mouseY);
        this.playSound(noteId);
        return super.m_6375_((double)mouseX, (double)mouseY, mouseButton);
    }

    public boolean m_6348_(double dmouseX, double dmouseY, int mouseButton) {
        int mouseX = (int)Math.round(dmouseX);
        int mouseY = (int)Math.round(dmouseY);
        int noteId = this.noteIdFromPos(mouseX, mouseY);
        this.stopSound(noteId);
        return super.m_6348_(dmouseX, dmouseY, mouseButton);
    }

    public boolean m_7979_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        int currentNoteId;
        int prevMouseY;
        int mouseX = (int)Math.round(posX);
        int mouseY = (int)Math.round(posY);
        int prevMouseX = (int)Math.round(posX - deltaX);
        int prevNoteId = this.noteIdFromPos(prevMouseX, prevMouseY = (int)Math.round(posY - deltaY));
        if (prevNoteId != (currentNoteId = this.noteIdFromPos(mouseX, mouseY))) {
            this.stopSound(prevNoteId);
            this.playSound(currentNoteId);
        }
        return super.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.m_7522_(null);
        super.m_7933_(keyCode, scanCode, modifiers);
        int firstScanCode = GLFW.glfwGetKeyScancode((int)81);
        int lastScanCode = firstScanCode + 11;
        if (scanCode >= firstScanCode && scanCode <= lastScanCode) {
            int noteId = scanCode - firstScanCode + 12 * Math.max(0, currentKeyboardOctave);
            this.playSound(noteId);
        }
        if (keyCode == 65) {
            this.decreaseOctave();
        } else if (keyCode == 83) {
            this.increaseOctave();
        }
        return true;
    }

    private void decreaseOctave() {
        if (currentKeyboardOctave > -3) {
            this.midiHandler.currentOctave = --currentKeyboardOctave;
            this.stopAllSounds();
        }
    }

    private void increaseOctave() {
        if (currentKeyboardOctave < this.instrument.getMaxOctave()) {
            this.midiHandler.currentOctave = ++currentKeyboardOctave;
            this.stopAllSounds();
        }
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        int firstScanCode = GLFW.glfwGetKeyScancode((int)81);
        int lastScanCode = firstScanCode + 11;
        if (scanCode >= firstScanCode && scanCode <= lastScanCode) {
            int noteId = scanCode - firstScanCode + 12 * Math.max(0, currentKeyboardOctave);
            this.stopSound(noteId);
        }
        return true;
    }

    public void m_7861_() {
        this.midiHandler.closeDevices();
    }
}

