/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot.common;

import com.illusivesoulworks.elytraslot.client.ElytraRenderResult;
import com.illusivesoulworks.elytraslot.common.IElytraProvider;
import com.illusivesoulworks.elytraslot.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SimpleCompatibilityProvider
implements IElytraProvider {
    private static final Map<String, ResourceLocation> ID_TO_TEXTURE = new HashMap<String, ResourceLocation>();
    private static boolean init = false;

    @Override
    public boolean matches(ItemStack stack) {
        if (!init) {
            Predicate<String> isLoaded = Services.PLATFORM::isModLoaded;
            if (isLoaded.test("deeperdarker")) {
                ID_TO_TEXTURE.put("deeperdarker:soul_elytra", new ResourceLocation("deeperdarker:textures/entity/soul_elytra.png"));
            }
            if (isLoaded.test("enderitemod")) {
                ID_TO_TEXTURE.put("enderitemod:enderite_elytra_seperated", new ResourceLocation("minecraft:textures/entity/enderite_elytra.png"));
            }
            if (isLoaded.test("mekanism")) {
                ID_TO_TEXTURE.put("mekanism:hdpe_elytra", new ResourceLocation("mekanism:textures/entity/hdpe_elytra.png"));
            }
            if (isLoaded.test("alexsmobs")) {
                ID_TO_TEXTURE.put("alexsmobs:tarantula_hawk_elytra", new ResourceLocation(""));
            }
            if (isLoaded.test("mna")) {
                ID_TO_TEXTURE.put("mna:spectral_elytra", new ResourceLocation("mna:textures/entity/elytra.png"));
            }
            if (isLoaded.test("netherelytra")) {
                ID_TO_TEXTURE.put("netherelytra:netherite_elytra", new ResourceLocation("netherelytra:textures/entity/netherite_elytra.png"));
            }
            if (isLoaded.test("lilwings")) {
                Set<ResourceLocation> entityTypes = Services.PLATFORM.getEntityTypes();
                for (ResourceLocation entityType : entityTypes) {
                    if (!entityType.m_135827_().equals("lilwings")) continue;
                    String name = entityType.m_135815_().substring(0, entityType.m_135815_().lastIndexOf("_")) + "_elytra";
                    ID_TO_TEXTURE.put("lilwings:" + name, new ResourceLocation("lilwings", "textures/elytra/" + name + ".png"));
                }
            }
            init = true;
        }
        return ID_TO_TEXTURE.containsKey(Services.PLATFORM.getId(stack.m_41720_()).toString());
    }

    @Override
    public ElytraRenderResult getRender(ItemStack stack) {
        return new ElytraRenderResult(COLOR, ID_TO_TEXTURE.get(Services.PLATFORM.getId(stack.m_41720_()).toString()), stack.m_41793_(), stack, this.hasCapeTexture(stack));
    }

    @Override
    public boolean hasCapeTexture(ItemStack stack) {
        ResourceLocation rl = Services.PLATFORM.getId(stack.m_41720_());
        if (rl != null) {
            if (Services.PLATFORM.isModLoaded("deeperdarker") && rl.toString().equals("deeperdarker:soul_elytra")) {
                return false;
            }
            if (Services.PLATFORM.isModLoaded("lilwings") && rl.m_135827_().equals("lilwings")) {
                return false;
            }
        }
        return true;
    }
}

