/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot;

import com.illusivesoulworks.elytraslot.ElytraSlotCommonMod;
import com.illusivesoulworks.elytraslot.ElytraSlotForgeClientMod;
import com.illusivesoulworks.elytraslot.common.CurioElytra;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.CuriosCapability;

@Mod(value="elytraslot")
public class ElytraSlotForgeMod {
    public ElytraSlotForgeMod() {
        ElytraSlotCommonMod.init();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ElytraSlotForgeClientMod.setup();
    }

    private void playerTick(TickEvent.PlayerTickEvent evt) {
        Player player = evt.player;
        AttributeInstance attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
        if (attributeInstance != null) {
            attributeInstance.m_22130_(CurioElytra.ELYTRA_CURIO_MODIFIER);
            if (!attributeInstance.m_22109_(CurioElytra.ELYTRA_CURIO_MODIFIER) && ElytraSlotCommonMod.canFly((LivingEntity)player, false)) {
                attributeInstance.m_22118_(CurioElytra.ELYTRA_CURIO_MODIFIER);
            }
        }
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (ElytraSlotCommonMod.IS_ELYTRA.test(stack)) {
            final LazyOptional elytraCurio = LazyOptional.of(() -> new CurioElytra(stack));
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, elytraCurio);
                }
            });
            evt.addListener(() -> ((LazyOptional)elytraCurio).invalidate());
        }
    }
}

