/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.data;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;

public record SwapData(UUID entityUUID, Action action) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.m_130068_((Enum)this.action);
    }

    public static SwapData decode(FriendlyByteBuf packetBuffer) {
        return new SwapData(packetBuffer.m_130259_(), (Action)packetBuffer.m_130066_(Action.class));
    }

    public void handleData(ArmorStand armorStand) {
        switch (this.action) {
            case SWAP_HANDS: {
                ItemStack offStack = armorStand.m_21120_(InteractionHand.OFF_HAND);
                armorStand.m_21008_(InteractionHand.OFF_HAND, armorStand.m_21120_(InteractionHand.MAIN_HAND));
                armorStand.m_21008_(InteractionHand.MAIN_HAND, offStack);
                return;
            }
            case SWAP_WITH_HEAD: {
                ItemStack headStack = armorStand.m_6844_(EquipmentSlot.HEAD);
                armorStand.m_8061_(EquipmentSlot.HEAD, armorStand.m_6844_(EquipmentSlot.MAINHAND));
                armorStand.m_8061_(EquipmentSlot.MAINHAND, headStack);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Pose action");
    }

    public static enum Action {
        SWAP_WITH_HEAD,
        SWAP_HANDS;

    }
}

