/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.widgets.NumberFieldBox;
import com.mrbysco.armorposer.client.gui.widgets.PoseButton;
import com.mrbysco.armorposer.client.gui.widgets.PoseImageButton;
import com.mrbysco.armorposer.client.gui.widgets.ToggleButton;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.platform.Services;
import com.mrbysco.armorposer.util.ArmorStandData;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec3;

public class ArmorStandScreen
extends Screen {
    private final ArmorStand entityArmorStand;
    private final ArmorStandData armorStandData;
    private final String[] buttonLabels = new String[]{"invisible", "no_base_plate", "no_gravity", "show_arms", "small", "name_visible", "rotation"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm", "position"};
    private NumberFieldBox rotationTextField;
    private final ToggleButton[] toggleButtons = new ToggleButton[6];
    private final NumberFieldBox[] poseTextFields = new NumberFieldBox[21];
    private final PoseButton[] poseButtons = new PoseButton[Reference.defaultPoseMap.size()];
    private final boolean allowScrolling;
    private boolean poseTabVisible = false;
    private Vec3 lastSendOffset = new Vec3(0.0, 0.0, 0.0);
    private final Tooltip yPositionTooltip = Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.y_position"));
    private final Tooltip yPositionTooltipDisabled = Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.y_position.disabled").m_130940_(ChatFormatting.RED));

    public ArmorStandScreen(ArmorStand entityArmorStand) {
        super(GameNarrator.f_93310_);
        this.entityArmorStand = entityArmorStand;
        this.armorStandData = new ArmorStandData();
        this.armorStandData.readFromNBT(entityArmorStand.m_20240_(new CompoundTag()));
        this.allowScrolling = Services.PLATFORM.allowScrolling();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        int height;
        int width;
        int y;
        int x;
        int i;
        super.m_7856_();
        int offsetX = 110;
        int offsetY = 20;
        for (i = 0; i < this.toggleButtons.length; ++i) {
            x = offsetX;
            y = offsetY + i * 22;
            width = 40;
            height = 20;
            this.toggleButtons[i] = new ToggleButton.Builder(this.armorStandData.getBooleanValue(i), button -> {
                ToggleButton toggleButton;
                toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
                this.textFieldUpdated();
            }).bounds(x, y, width, height).build();
            this.m_142416_((GuiEventListener)this.toggleButtons[i]);
            this.toggleButtons[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("armorposer.gui.tooltip." + this.buttonLabels[i]))));
        }
        this.rotationTextField = new NumberFieldBox(this.f_96547_, 1 + offsetX, 1 + offsetY + this.toggleButtons.length * 22, 38, 17, (Component)Component.m_237115_((String)"armorposer.gui.label.rotation"));
        this.rotationTextField.m_94144_(String.valueOf((int)this.armorStandData.rotation));
        this.rotationTextField.m_94199_(4);
        this.m_7787_((GuiEventListener)this.rotationTextField);
        this.rotationTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.rotation")));
        offsetX = this.f_96543_ - 20 - 100;
        for (i = 0; i < this.poseTextFields.length; ++i) {
            boolean lastRow;
            x = 1 + offsetX + i % 3 * 35;
            y = 1 + offsetY + i / 3 * 22;
            width = 28;
            height = 17;
            String value = String.valueOf((int)this.armorStandData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.f_96547_, x, y, width, height, (Component)Component.m_237113_((String)value));
            this.poseTextFields[i].m_94144_(value);
            this.poseTextFields[i].m_94199_(4);
            boolean bl = lastRow = i >= 18 && i < 21;
            if (lastRow) {
                this.poseTextFields[i].scrollMultiplier = 0.01f;
                this.poseTextFields[i].modValue = 2.1474836E9f;
                this.poseTextFields[i].decimalPoints = 2;
                this.poseTextFields[i].m_94199_(6);
            }
            if (i % 3 == 0) {
                this.poseTextFields[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("armorposer.gui.tooltip." + (lastRow ? "x_position" : "x_rotation")))));
            } else if (i % 3 == 1) {
                this.poseTextFields[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("armorposer.gui.tooltip." + (lastRow ? "y_position" : "y_rotation")))));
            } else {
                this.poseTextFields[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("armorposer.gui.tooltip." + (lastRow ? "z_position" : "z_rotation")))));
            }
            this.m_7787_((GuiEventListener)this.poseTextFields[i]);
        }
        offsetY = this.f_96544_ / 4 + 134;
        offsetX = 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"armorposer.gui.label.poses"), button -> {
            this.poseTabVisible = !this.poseTabVisible;
        }).m_252987_(offsetX, offsetY, 130, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.poses"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"armorposer.gui.label.copy"), button -> {
            CompoundTag compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.f_96541_ != null) {
                this.f_96541_.f_91068_.m_90911_(clipboardData);
            }
        }).m_252987_(offsetX, offsetY + 22, 64, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.copy"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"armorposer.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.f_96541_ != null) {
                    clipboardData = this.f_96541_.f_91068_.m_90876_();
                }
                if (clipboardData != null) {
                    CompoundTag compound = TagParser.m_129359_(clipboardData);
                    this.readFieldsFromNBT(compound);
                    this.updateEntity(compound);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).m_252987_(offsetX + 66, offsetY + 22, 64, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.paste"))).m_253136_());
        offsetX = this.f_96543_ - 20;
        this.m_142416_((GuiEventListener)new PoseImageButton(offsetX - 110 - 41, offsetY, button -> {
            float[] head = new float[]{this.poseTextFields[0].getFloat(), this.poseTextFields[1].getFloat(), this.poseTextFields[2].getFloat()};
            this.poseTextFields[0].m_94144_(String.valueOf(head[0]));
            this.poseTextFields[1].m_94144_(String.valueOf(head[1] != 0.0f ? -head[1] : 0.0f));
            this.poseTextFields[2].m_94144_(String.valueOf(head[2] != 0.0f ? -head[2] : 0.0f));
            float[] body = new float[]{this.poseTextFields[3].getFloat(), this.poseTextFields[4].getFloat(), this.poseTextFields[5].getFloat()};
            this.poseTextFields[3].m_94144_(String.valueOf(body[0]));
            this.poseTextFields[4].m_94144_(String.valueOf(body[1] != 0.0f ? -body[1] : 0.0f));
            this.poseTextFields[5].m_94144_(String.valueOf(body[2] != 0.0f ? -body[2] : 0.0f));
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].m_94144_(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].m_94144_(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].m_94144_(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].m_94144_(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].m_94144_(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].m_94144_(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].m_94144_(String.valueOf(rightArm[0]));
            this.poseTextFields[13].m_94144_(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].m_94144_(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].m_94144_(String.valueOf(leftArm[0]));
            this.poseTextFields[16].m_94144_(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].m_94144_(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
        }, 0, Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.mirror"))));
        this.m_142416_((GuiEventListener)new PoseImageButton(offsetX - 88 - 41, offsetY, button -> {
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].m_94144_(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].m_94144_(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].m_94144_(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].m_94144_(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].m_94144_(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].m_94144_(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
        }, 1, Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.mirror_legs"))));
        this.m_142416_((GuiEventListener)new PoseImageButton(offsetX - 66 - 41, offsetY, button -> {
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].m_94144_(String.valueOf(rightArm[0]));
            this.poseTextFields[13].m_94144_(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].m_94144_(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].m_94144_(String.valueOf(leftArm[0]));
            this.poseTextFields[16].m_94144_(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].m_94144_(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
        }, 2, Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.mirror_arms"))));
        this.m_142416_((GuiEventListener)new PoseImageButton(offsetX - 44 - 41, offsetY, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_WITH_HEAD), 3, Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.swap_head"))));
        this.m_142416_((GuiEventListener)new PoseImageButton(offsetX - 22 - 41, offsetY, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_HANDS), 4, Tooltip.m_257550_((Component)Component.m_237115_((String)"armorposer.gui.tooltip.swap_hands"))));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            this.updateEntity(this.writeFieldsToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }).m_252987_(offsetX - 194, offsetY + 22, 96, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> {
            this.poseTextFields[18].m_94144_("0");
            this.poseTextFields[19].m_94144_("0");
            this.poseTextFields[20].m_94144_("0");
            this.textFieldUpdated();
            this.updateEntity(this.armorStandData.writeToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }).m_252987_(offsetX - 96, offsetY + 22, 96, 20).m_253136_());
        int centerX = this.f_96543_ / 2;
        int exclusionLeft = centerX - 60;
        int exclusionRight = centerX + 80;
        offsetX = 10;
        offsetY = 10;
        int id = 0;
        for (Map.Entry<String, String> entry : Reference.defaultPoseMap.entrySet()) {
            String poseID = entry.getKey();
            String tag = entry.getValue();
            int buttonEnd = offsetX + 40;
            if (buttonEnd >= exclusionLeft && buttonEnd <= exclusionRight) {
                offsetX = exclusionRight;
            }
            this.poseButtons[id] = new PoseButton.Builder(poseID, tag, button -> {
                PoseButton poseButton = (PoseButton)button;
                if (poseButton.getPoseID().equals("random")) {
                    for (int i = 0; i < this.poseTextFields.length - 3; ++i) {
                        float randomRotation = (float)(Math.random() * 70.0 - 35.0);
                        this.poseTextFields[i].m_94144_(String.valueOf((int)randomRotation));
                    }
                } else {
                    this.readFieldsFromNBT(poseButton.getTag());
                }
                this.updateEntity(poseButton.getTag());
            }).pos(offsetX, offsetY).build();
            this.m_142416_((GuiEventListener)this.poseButtons[id]);
            this.poseButtons[id].f_93624_ = this.poseTabVisible;
            ++id;
            if ((offsetX += 44) + 40 <= this.f_96543_) continue;
            offsetX = 10;
            offsetY += 44;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"armorposer.gui.title"), this.f_96543_ / 2, 10, 0xFFFFFF);
        this.rotationTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        int offsetY = 20;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.f_96547_);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            if (this.poseTabVisible) continue;
            guiGraphics.m_280056_(this.f_96547_, I18n.m_118938_((String)("armorposer.gui.label." + this.buttonLabels[i]), (Object[])new Object[0]), x, y, 0xA0A0A0, false);
        }
        offsetX = this.f_96543_ - 20 - 100;
        if (!this.poseTabVisible) {
            guiGraphics.m_280056_(this.f_96547_, "X", offsetX + 10, 7, 0xA0A0A0, false);
            guiGraphics.m_280056_(this.f_96547_, "Y", offsetX + 45, 7, 0xA0A0A0, false);
            guiGraphics.m_280056_(this.f_96547_, "Z", offsetX + 80, 7, 0xA0A0A0, false);
        }
        for (i = 0; i < this.sliderLabels.length; ++i) {
            String translatedLabel = I18n.m_118938_((String)("armorposer.gui.label." + this.sliderLabels[i]), (Object[])new Object[0]);
            int x = offsetX - this.f_96547_.m_92895_(translatedLabel) - 10;
            Objects.requireNonNull(this.f_96547_);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            if (this.poseTabVisible) continue;
            guiGraphics.m_280056_(this.f_96547_, translatedLabel, x, y, 0xA0A0A0, false);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - void declaration
     */
    public void m_86600_() {
        void var3_6;
        super.m_86600_();
        this.rotationTextField.m_94120_();
        NumberFieldBox[] numberFieldBoxArray = this.poseTextFields;
        int n = numberFieldBoxArray.length;
        boolean bl = false;
        while (var3_6 < n) {
            NumberFieldBox textField = numberFieldBoxArray[var3_6];
            if (textField != null) {
                textField.m_94120_();
            }
            ++var3_6;
        }
        boolean disabledGravity = this.toggleButtons[2].getValue();
        NumberFieldBox yPositionField = this.poseTextFields[19];
        yPositionField.m_94186_(disabledGravity);
        if (disabledGravity) {
            yPositionField.m_257544_(this.yPositionTooltip);
        } else {
            yPositionField.m_93692_(false);
            yPositionField.m_257544_(this.yPositionTooltipDisabled);
        }
        if (this.poseTabVisible) {
            for (PoseButton poseButton : this.poseButtons) {
                poseButton.f_93624_ = true;
            }
            this.rotationTextField.f_93624_ = false;
            for (ToggleButton toggleButton : this.toggleButtons) {
                toggleButton.f_93624_ = false;
            }
            for (NumberFieldBox numberFieldBox : this.poseTextFields) {
                numberFieldBox.f_93624_ = false;
            }
        } else {
            for (PoseButton poseButton : this.poseButtons) {
                poseButton.f_93624_ = false;
            }
            this.rotationTextField.f_93624_ = true;
            for (ToggleButton toggleButton : this.toggleButtons) {
                toggleButton.f_93624_ = true;
            }
            for (NumberFieldBox numberFieldBox : this.poseTextFields) {
                numberFieldBox.f_93624_ = true;
            }
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean typed = super.m_5534_(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        block5: {
            float multiplier;
            block4: {
                float f = multiplier = Screen.m_96638_() ? 10.0f : 1.0f;
                if (!this.allowScrolling || !(delta > 0.0)) break block4;
                if (this.rotationTextField.m_94204_()) {
                    float nextValue = (this.rotationTextField.getFloat() + multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                    this.rotationTextField.m_94144_(String.valueOf(nextValue));
                    this.rotationTextField.m_94196_(0);
                    this.rotationTextField.m_94208_(0);
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldBox textField : this.poseTextFields) {
                    if (!textField.m_94204_()) continue;
                    float nextValue = (textField.getFloat() + multiplier * textField.scrollMultiplier) % textField.modValue;
                    textField.m_94144_(String.valueOf(nextValue));
                    textField.m_94196_(0);
                    textField.m_94208_(0);
                    this.textFieldUpdated();
                    return true;
                }
                break block5;
            }
            if (!this.allowScrolling || !(delta < 0.0)) break block5;
            if (this.rotationTextField.m_94204_()) {
                float previousValue = (this.rotationTextField.getFloat() - multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                this.rotationTextField.m_94144_(String.valueOf(previousValue));
                this.rotationTextField.m_94196_(0);
                this.rotationTextField.m_94208_(0);
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.m_94204_()) continue;
                float previousValue = (textField.getFloat() - multiplier * textField.scrollMultiplier) % textField.modValue;
                textField.m_94144_(String.valueOf(previousValue));
                textField.m_94196_(0);
                textField.m_94208_(0);
                this.textFieldUpdated();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].m_93696_()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].m_94201_();
                this.poseTextFields[i].m_93692_(false);
                int j = !Screen.m_96638_() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].m_93692_(true);
                this.poseTextFields[j].m_94192_(0);
                this.poseTextFields[j].m_94208_(this.poseTextFields[j].m_94155_().length());
            }
        } else {
            if (this.rotationTextField.m_7933_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            this.textFieldUpdated();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clicked = super.m_6375_(mouseX, mouseY, button);
        this.textFieldUpdated();
        return clicked;
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    private CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Invisible", this.toggleButtons[0].getValue());
        compound.m_128379_("NoBasePlate", this.toggleButtons[1].getValue());
        compound.m_128379_("NoGravity", this.toggleButtons[2].getValue());
        compound.m_128379_("ShowArms", this.toggleButtons[3].getValue());
        compound.m_128379_("Small", this.toggleButtons[4].getValue());
        compound.m_128379_("CustomNameVisible", this.toggleButtons[5].getValue());
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.m_128566_((float)this.rotationTextField.getFloat()));
        compound.m_128365_("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[0].getFloat()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[1].getFloat()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[2].getFloat()));
        poseTag.m_128365_("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[3].getFloat()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[4].getFloat()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[5].getFloat()));
        poseTag.m_128365_("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[6].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[7].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[8].getFloat()));
        poseTag.m_128365_("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[9].getFloat()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[10].getFloat()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[11].getFloat()));
        poseTag.m_128365_("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[12].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[13].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[14].getFloat()));
        poseTag.m_128365_("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[15].getFloat()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[16].getFloat()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[17].getFloat()));
        poseTag.m_128365_("RightArm", (Tag)poseRightArmTag);
        float offsetX = this.poseTextFields[18].getFloat();
        float offsetY = this.poseTextFields[19].getFloat();
        float offsetZ = this.poseTextFields[20].getFloat();
        double offsetXDiff = (double)offsetX - this.lastSendOffset.f_82479_;
        double offsetYDiff = (double)offsetY - this.lastSendOffset.f_82480_;
        double offsetZDiff = (double)offsetZ - this.lastSendOffset.f_82481_;
        ListTag positionOffset = new ListTag();
        positionOffset.add((Object)DoubleTag.m_128500_((double)offsetXDiff));
        positionOffset.add((Object)DoubleTag.m_128500_((double)offsetYDiff));
        positionOffset.add((Object)DoubleTag.m_128500_((double)offsetZDiff));
        compound.m_128365_("Move", (Tag)positionOffset);
        this.lastSendOffset = new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
        compound.m_128365_("Pose", (Tag)poseTag);
        return compound;
    }

    private void readFieldsFromNBT(CompoundTag compound) {
        CompoundTag armorStandTag = this.armorStandData.writeToNBT();
        armorStandTag.m_128391_(compound);
        this.armorStandData.readFromNBT(armorStandTag);
        this.rotationTextField.m_94144_(String.valueOf((int)this.armorStandData.rotation));
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            this.poseTextFields[i].m_94144_(String.valueOf((int)this.armorStandData.pose[i]));
        }
    }

    public static void openScreen(ArmorStand armorStandEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new ArmorStandScreen(armorStandEntity));
    }

    public void updateEntity(CompoundTag compound) {
        Services.PLATFORM.updateEntity(this.entityArmorStand, compound);
    }
}

