/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityAttackPacket {
    public int entityId;

    public AuthorityAttackPacket() {
    }

    public AuthorityAttackPacket(Entity e) {
        this.entityId = e.m_19879_();
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public static void encode(AuthorityAttackPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static AuthorityAttackPacket decode(FriendlyByteBuf buf) {
        AuthorityAttackPacket msg = new AuthorityAttackPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final AuthorityAttackPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                Level world = player.m_9236_();
                Entity e = world.m_6815_(message.entityId);
                AuthorityAttackPacket.doAttack((Player)player, e);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void doAttack(Player player, Entity entity) {
        if (entity != null && player != null && entity != player && entity instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY) && !EffectUtil.hasBuff((LivingEntity)entity, ModEffects.BA_COOLDOWN) && entity.m_6084_()) {
            player.m_5706_(entity);
        }
    }
}

