/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.network.RouterFilterPacket;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ScreenFilter
extends ScreenBase<ContainerFilter> {
    private static final ResourceLocation background = BloodMagic.rl("textures/gui/routingfilter.png");
    public Container filterInventory;
    private Player player;
    private int left;
    private int top;
    private EditBox textBox;
    private int numberOfAddedButtons = 0;
    private List<String> buttonKeyList = new ArrayList<String>();
    private List<Button> buttonList = new ArrayList<Button>();

    public ScreenFilter(ContainerFilter container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.filterInventory = container.inventoryFilter;
        this.f_97726_ = 176;
        this.f_97727_ = 187;
        this.player = playerInventory.f_35978_;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.f_97726_) / 2;
        this.top = (this.f_96544_ - this.f_97727_) / 2;
        this.textBox = new EditBox(Minecraft.m_91087_().f_91062_, this.left + 23, this.top + 19, 70, 12, (Component)Component.m_237113_((String)"itemGroup.search"));
        this.textBox.m_94182_(false);
        this.textBox.m_94199_(50);
        this.textBox.m_94194_(true);
        this.textBox.m_94202_(0xFFFFFF);
        this.textBox.m_94144_("");
        this.numberOfAddedButtons = 0;
        this.buttonKeyList.clear();
        ItemStack filterStack = ((ContainerFilter)this.container).filterStack;
        if (filterStack.m_41720_() instanceof IItemFilterProvider) {
            IItemFilterProvider provider = (IItemFilterProvider)filterStack.m_41720_();
            List<Pair<String, Button.OnPress>> buttonActionList = provider.getButtonAction((ContainerFilter)this.container);
            for (Pair<String, Button.OnPress> pair : buttonActionList) {
                if (this.buttonKeyList.contains(pair.getKey())) continue;
                this.buttonKeyList.add((String)pair.getKey());
                Pair<Integer, Integer> buttonLocation = this.getButtonLocation(this.numberOfAddedButtons);
                Button addedButton = Button.m_253074_((Component)Component.m_237113_((String)""), (Button.OnPress)((Button.OnPress)pair.getRight())).m_252794_(this.left + (Integer)buttonLocation.getLeft(), this.top + (Integer)buttonLocation.getRight()).m_253046_(20, 20).m_253136_();
                if (!provider.isButtonGlobal(filterStack, (String)pair.getKey())) {
                    addedButton.f_93623_ = false;
                }
                this.m_142416_((GuiEventListener)addedButton);
                this.buttonList.add(addedButton);
                ++this.numberOfAddedButtons;
            }
        }
    }

    public Pair<Integer, Integer> getButtonLocation(int addedButton) {
        int x = 7;
        int y = 32;
        return Pair.of((Object)(x += addedButton * 20), (Object)y);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.textBox.m_94120_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String str;
        if (this.textBox.m_93696_() && (keyCode == 259 || keyCode == 261) && ((ContainerFilter)this.container).lastGhostSlotClicked != -1 && (str = this.textBox.m_94155_()) != null && str.length() > 0) {
            str = str.substring(0, str.length() - 1);
            this.textBox.m_94144_(str);
            int amount = 0;
            if (str.length() > 0) {
                try {
                    Integer testVal = Integer.decode(str);
                    if (testVal != null) {
                        amount = testVal;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.setValueOfGhostItemInSlot(((ContainerFilter)this.container).lastGhostSlotClicked, amount);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        block8: {
            try {
                Integer charVal = Integer.decode("" + typedChar);
                if (charVal == null) break block8;
                if (this.textBox.m_5534_(typedChar, keyCode)) {
                    if (((ContainerFilter)this.container).lastGhostSlotClicked != -1) {
                        String str = this.textBox.m_94155_();
                        int amount = 0;
                        if (!str.isEmpty()) {
                            try {
                                Integer testVal = Integer.decode(str);
                                if (testVal != null) {
                                    amount = testVal;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        this.setValueOfGhostItemInSlot(((ContainerFilter)this.container).lastGhostSlotClicked, amount);
                    }
                    return true;
                }
                return super.m_5534_(typedChar, keyCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.m_5534_(typedChar, keyCode);
    }

    private void setValueOfGhostItemInSlot(int ghostItemSlot, int amount) {
        Slot slot = ((ContainerFilter)this.container).m_38853_(ghostItemSlot);
        ItemStack ghostStack = slot.m_7993_();
        if (!ghostStack.m_41619_()) {
            GhostItemHelper.setItemGhostAmount(ghostStack, amount);
            GhostItemHelper.setItemGhostAmount(((ContainerFilter)this.container).inventoryFilter.m_8020_(ghostItemSlot), amount);
            if (((ContainerFilter)this.container).filterStack.m_41720_() instanceof IItemFilterProvider) {
                ((IItemFilterProvider)((ContainerFilter)this.container).filterStack.m_41720_()).setGhostItemAmount(((ContainerFilter)this.container).filterStack, ghostItemSlot, amount);
            }
        }
        BloodMagic.packetHandler.sendToServer(new RouterFilterPacket(this.player.m_150109_().f_35977_, ghostItemSlot, amount));
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean testBool = super.m_6375_(mouseX, mouseY, mouseButton);
        if (this.textBox.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (((ContainerFilter)this.container).lastGhostSlotClicked != -1) {
            this.enableAllButtons();
            Slot slot = ((ContainerFilter)this.container).m_38853_(((ContainerFilter)this.container).lastGhostSlotClicked);
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount == 0) {
                    this.textBox.m_94144_("");
                } else {
                    this.textBox.m_94144_("" + amount);
                }
            } else {
                this.textBox.m_94144_("");
            }
        }
        return true;
    }

    private void enableAllButtons() {
        for (AbstractWidget abstractWidget : this.buttonList) {
            abstractWidget.f_93623_ = true;
        }
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"container.inventory"), 8, 93, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, ((ContainerFilter)this.container).filterStack.m_41786_(), 8, 4, 0x404040, false);
        if (((ContainerFilter)this.container).filterStack.m_41720_() instanceof IItemFilterProvider) {
            for (int i = 0; i < this.numberOfAddedButtons; ++i) {
                int currentButtonState = ((IItemFilterProvider)((ContainerFilter)this.container).filterStack.m_41720_()).getCurrentButtonState(((ContainerFilter)this.container).filterStack, this.buttonKeyList.get(i), ((ContainerFilter)this.container).lastGhostSlotClicked);
                Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
                Pair<Integer, Integer> textureLocation = ((IItemFilterProvider)((ContainerFilter)this.container).filterStack.m_41720_()).getTexturePositionForState(((ContainerFilter)this.container).filterStack, this.buttonKeyList.get(i), currentButtonState);
                int w = 20;
                int h = 20;
                int xl = (Integer)buttonLocation.getLeft();
                int yl = (Integer)buttonLocation.getRight();
                guiGraphics.m_280218_(background, xl, yl, ((Integer)textureLocation.getLeft()).intValue(), ((Integer)textureLocation.getRight()).intValue(), w, h);
            }
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(background, x, y, 0, 0, this.f_97726_, this.f_97727_);
        ItemStack held = this.player.m_21120_(InteractionHand.MAIN_HAND);
        if (((ContainerFilter)this.container).lastGhostSlotClicked >= 0) {
            guiGraphics.m_280218_(background, 106 + x + 21 * (((ContainerFilter)this.container).lastGhostSlotClicked % 3), y + 11 + 21 * (((ContainerFilter)this.container).lastGhostSlotClicked / 3), 0, 187, 24, 24);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.textBox.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (((ContainerFilter)this.container).filterStack.m_41720_() instanceof IItemFilterProvider) {
            for (int i = 0; i < this.numberOfAddedButtons; ++i) {
                List<Component> components;
                Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
                int w = 20;
                int h = 20;
                int x = this.f_97735_ + (Integer)buttonLocation.getLeft();
                int y = this.f_97736_ + (Integer)buttonLocation.getRight();
                if (mouseX < x || mouseX >= x + w || mouseY < y || mouseY >= y + h || (components = ((IItemFilterProvider)((ContainerFilter)this.container).filterStack.m_41720_()).getTextForHoverItem(((ContainerFilter)this.container).filterStack, this.buttonKeyList.get(i), ((ContainerFilter)this.container).lastGhostSlotClicked)) == null || components.isEmpty()) continue;
                tooltip.addAll(components);
            }
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

