/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mobenchant;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class MultiShotMobEnchant
extends MobEnchant {
    private static boolean isAdding = false;

    public MultiShotMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (!event.loadedFromDisk()) {
            Entity entity = event.getEntity();
            Level level = event.getLevel();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                if (!MultiShotMobEnchant.shooterIsLiving(projectile) || !((List)EnchantConfig.COMMON.ALLOW_MULTISHOT_PROJECTILE.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString())) {
                    return;
                }
                LivingEntity owner = (LivingEntity)projectile.m_19749_();
                MobEnchantUtils.executeIfPresent((Entity)owner, (MobEnchant)MobEnchants.MULTISHOT.get(), () -> {
                    if (!level.f_46443_ && projectile.f_19797_ == 0 && !isAdding) {
                        isAdding = true;
                        CompoundTag compoundNBT = new CompoundTag();
                        compoundNBT = projectile.m_20240_(compoundNBT);
                        MultiShotMobEnchant.addProjectile(projectile, compoundNBT, level, 15.0f);
                        MultiShotMobEnchant.addProjectile(projectile, compoundNBT, level, -15.0f);
                        isAdding = false;
                    }
                });
            }
        }
    }

    private static void addProjectile(Projectile projectile, CompoundTag compoundNBT, Level level, float rotation) {
        Projectile newProjectile = (Projectile)projectile.m_6095_().m_20615_(level);
        UUID uuid = newProjectile.m_20148_();
        newProjectile.m_20258_(compoundNBT);
        newProjectile.m_20084_(uuid);
        Vec3 vector3d = newProjectile.m_20184_().m_82524_((float)(Math.PI / (double)rotation));
        newProjectile.m_20256_(vector3d);
        float f = Mth.m_14116_((float)((float)vector3d.m_165925_()));
        newProjectile.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        newProjectile.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        newProjectile.f_19859_ = newProjectile.m_146908_();
        newProjectile.f_19860_ = newProjectile.m_146909_();
        if (newProjectile instanceof Projectile) {
            Projectile newDamagingProjectile = newProjectile;
            Vec3 newPower = new Vec3(newDamagingProjectile.m_20184_().f_82479_, newDamagingProjectile.m_20184_().f_82480_, newDamagingProjectile.m_20184_().f_82481_).m_82524_((float)(Math.PI / (double)rotation));
            newDamagingProjectile.m_20256_(newPower);
        }
        if (newProjectile instanceof AbstractArrow) {
            ((AbstractArrow)newProjectile).f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        newProjectile.getCapability(EnchantWithMob.ITEM_MOB_ENCHANT_CAP).ifPresent(cap -> cap.setHasEnchant(true));
        level.m_7967_((Entity)newProjectile);
    }

    public static boolean shooterIsLiving(Projectile projectile) {
        return projectile.m_19749_() != null && projectile.m_19749_() instanceof LivingEntity;
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 10;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 40;
    }

    @Override
    public boolean isCompatibleMob(LivingEntity livingEntity) {
        return ((List)EnchantConfig.COMMON.WHITELIST_SHOOT_ENTITY.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)livingEntity.m_6095_()).toString()) || livingEntity instanceof Player;
    }
}

