/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class LegacySmithingTransformRecipe
extends CustomRecipe {
    public static final String RECIPE_SERIALIZER_ID = "legacy_smithing_transform";
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;

    public LegacySmithingTransformRecipe(ResourceLocation id, CraftingBookCategory category, Ingredient base, Ingredient addition, ItemStack result) {
        super(id, category);
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public static RecipeSerializer<?> getModSerializer(String modId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(new ResourceLocation(modId, RECIPE_SERIALIZER_ID));
        Objects.requireNonNull(recipeSerializer, "legacy smithing transform recipe serializer for %s is null".formatted(modId));
        return recipeSerializer;
    }

    public boolean matches(CraftingContainer container, Level level) {
        int baseItemCount = 0;
        int additionItemCount = 0;
        for (int k = 0; k < container.m_6643_(); ++k) {
            ItemStack itemStack = container.m_8020_(k);
            if (itemStack.m_41619_()) continue;
            if (this.base.test(itemStack)) {
                ++baseItemCount;
            } else if (this.addition.test(itemStack)) {
                ++additionItemCount;
            } else {
                return false;
            }
            if (additionItemCount <= 1 && baseItemCount <= 1) continue;
            return false;
        }
        return baseItemCount == 1 && additionItemCount == 1;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = this.result.m_41777_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!this.base.test(itemStack)) continue;
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag != null) {
                result.m_41751_(compoundTag.m_6426_());
            }
            return result;
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.base);
        nonNullList.add((Object)this.addition);
        return nonNullList;
    }

    public boolean m_5598_() {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return LegacySmithingTransformRecipe.getModSerializer(this.m_6423_().m_135827_());
    }

    public static class Serializer
    implements RecipeSerializer<LegacySmithingTransformRecipe> {
        public LegacySmithingTransformRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"addition"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new LegacySmithingTransformRecipe(resourceLocation, craftingBookCategory, base, addition, result);
        }

        public LegacySmithingTransformRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)friendlyByteBuf.m_130066_(CraftingBookCategory.class);
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            ItemStack result = friendlyByteBuf.m_130267_();
            return new LegacySmithingTransformRecipe(resourceLocation, craftingBookCategory, base, addition, result);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, LegacySmithingTransformRecipe smithingTransformRecipe) {
            friendlyByteBuf.m_130068_((Enum)smithingTransformRecipe.m_245232_());
            smithingTransformRecipe.base.m_43923_(friendlyByteBuf);
            smithingTransformRecipe.addition.m_43923_(friendlyByteBuf);
            friendlyByteBuf.m_130055_(smithingTransformRecipe.result);
        }
    }
}

