/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v2;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.init.v2.RegistryReference;
import fuzs.puzzleslib.api.init.v2.builder.ExtendedMenuSupplier;
import fuzs.puzzleslib.api.init.v2.builder.PoiTypeBuilder;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public interface RegistryManager {
    public static RegistryManager instant(String modId) {
        return ModContext.get(modId).getRegistryManager();
    }

    public ResourceLocation makeKey(String var1);

    public RegistryManager whenOn(ModLoader ... var1);

    default public RegistryManager whenNotOn(ModLoader ... forbiddenModLoaders) {
        Objects.checkIndex(0, forbiddenModLoaders.length);
        return this.whenOn((ModLoader[])EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(forbiddenModLoaders), ModLoader.class)).toArray(ModLoader[]::new));
    }

    default public <T> RegistryReference<T> placeholder(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        return RegistryReference.placeholder(registryKey, this.makeKey(path));
    }

    public <T> RegistryReference<T> register(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3);

    default public RegistryReference<Block> registerBlock(String path, Supplier<Block> entry) {
        return this.register(Registries.f_256747_, path, entry);
    }

    default public RegistryReference<Item> registerItem(String path, Supplier<Item> entry) {
        return this.register(Registries.f_256913_, path, entry);
    }

    default public RegistryReference<Item> registerBlockItem(RegistryReference<Block> blockReference) {
        return this.registerBlockItem(blockReference, new Item.Properties());
    }

    default public RegistryReference<Item> registerBlockItem(RegistryReference<Block> blockReference, Item.Properties itemProperties) {
        return this.registerItem(blockReference.getResourceLocation().m_135815_(), () -> new BlockItem((Block)blockReference.get(), itemProperties));
    }

    default public RegistryReference<Item> registerSpawnEggItem(RegistryReference<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeReference, backgroundColor, highlightColor, new Item.Properties());
    }

    public RegistryReference<Item> registerSpawnEggItem(RegistryReference<? extends EntityType<? extends Mob>> var1, int var2, int var3, Item.Properties var4);

    default public RegistryReference<Fluid> registerFluid(String path, Supplier<Fluid> entry) {
        return this.register(Registries.f_256808_, path, entry);
    }

    default public RegistryReference<MobEffect> registerMobEffect(String path, Supplier<MobEffect> entry) {
        return this.register(Registries.f_256929_, path, entry);
    }

    default public RegistryReference<SoundEvent> registerSoundEvent(String path) {
        return this.register(Registries.f_256840_, path, () -> SoundEvent.m_262824_((ResourceLocation)this.makeKey(path)));
    }

    default public RegistryReference<Potion> registerPotion(String path, Supplier<Potion> entry) {
        return this.register(Registries.f_256973_, path, entry);
    }

    default public RegistryReference<Enchantment> registerEnchantment(String path, Supplier<Enchantment> entry) {
        return this.register(Registries.f_256762_, path, entry);
    }

    default public <T extends Entity> RegistryReference<EntityType<T>> registerEntityType(String path, Supplier<EntityType.Builder<T>> entry) {
        return this.register(Registries.f_256939_, path, () -> ((EntityType.Builder)entry.get()).m_20712_(path));
    }

    default public <T extends BlockEntity> RegistryReference<BlockEntityType<T>> registerBlockEntityType(String path, Supplier<BlockEntityType.Builder<T>> entry) {
        return this.register(Registries.f_256922_, path, () -> ((BlockEntityType.Builder)entry.get()).m_58966_(null));
    }

    default public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerMenuType(String path, Supplier<MenuType.MenuSupplier<T>> entry) {
        return this.register(Registries.f_256798_, path, () -> new MenuType((MenuType.MenuSupplier)entry.get(), FeatureFlags.f_244332_));
    }

    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerExtendedMenuType(String var1, Supplier<ExtendedMenuSupplier<T>> var2);

    @Deprecated(forRemoval=true)
    public RegistryReference<PoiType> registerPoiTypeBuilder(String var1, Supplier<PoiTypeBuilder> var2);

    default public RegistryReference<PoiType> registerPoiType(String path, Supplier<Set<Block>> blocks) {
        return this.registerPoiType(path, () -> ((Set)blocks.get()).stream().flatMap(t -> t.m_49965_().m_61056_().stream()).collect(Collectors.toSet()), 0, 1);
    }

    public RegistryReference<PoiType> registerPoiType(String var1, Supplier<Set<BlockState>> var2, int var3, int var4);

    default public <T extends Recipe<?>> RegistryReference<RecipeType<T>> registerRecipeType(final String path) {
        return this.register(Registries.f_256954_, path, () -> new RecipeType<T>(){
            private final String id;
            {
                this.id = RegistryManager.this.makeKey(path).toString();
            }

            public String toString() {
                return this.id;
            }
        });
    }

    default public RegistryReference<GameEvent> registerGameEvent(String path, int notificationRadius) {
        return this.register(Registries.f_256827_, path, () -> new GameEvent(path, notificationRadius));
    }

    default public RegistryReference<SimpleParticleType> registerParticleType(String path) {
        return this.register(Registries.f_256890_, path, () -> new SimpleParticleType(false));
    }

    default public <T> TagKey<T> registerTag(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return TagKey.m_203882_(registryKey, (ResourceLocation)this.makeKey(path));
    }

    default public TagKey<Block> registerBlockTag(String path) {
        return this.registerTag(Registries.f_256747_, path);
    }

    default public TagKey<Item> registerItemTag(String path) {
        return this.registerTag(Registries.f_256913_, path);
    }

    default public TagKey<EntityType<?>> registerEntityTypeTag(String path) {
        return this.registerTag(Registries.f_256939_, path);
    }

    default public TagKey<GameEvent> registerGameEventTag(String path) {
        return this.registerTag(Registries.f_256827_, path);
    }

    default public TagKey<DamageType> registerDamageTypeTag(String path) {
        return this.registerTag(Registries.f_268580_, path);
    }

    default public TagKey<Enchantment> registerEnchantmentTag(String path) {
        return this.registerTag(Registries.f_256762_, path);
    }

    default public TagKey<Biome> registerBiomeTag(String path) {
        return this.registerTag(Registries.f_256952_, path);
    }

    default public <T> ResourceKey<T> registerResourceKey(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return ResourceKey.m_135785_(registryKey, (ResourceLocation)this.makeKey(path));
    }

    default public ResourceKey<DamageType> registerDamageType(String path) {
        return this.registerResourceKey(Registries.f_268580_, path);
    }
}

