/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.setup.forge;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.setup.IDeferredCommonSetup;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class SetupHelperImpl {
    public static void deferSetup(IDeferredCommonSetup mod) {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Consumer<FMLCommonSetupEvent> setup = event -> {
            event.enqueueWork(mod::setup);
            mod.asyncSetup();
        };
        bus.addListener(setup);
        if (SetupHelperImpl.hasImpl(mod, "registerServerReloadListener")) {
            Consumer<AddReloadListenerEvent> listener = event -> mod.registerServerReloadListener((s, r) -> event.addListener((PreparableReloadListener)s.get()));
            forgeBus.addListener(listener);
        }
        Consumer<EntityAttributeCreationEvent> attribute = event -> mod.registerAttributes((e, b) -> event.put(e, b.m_22265_()));
        bus.addListener(attribute);
        Consumer<SpawnPlacementRegisterEvent> spawn = event -> mod.registerSpawnPlacements(new PlacementEventImpl((SpawnPlacementRegisterEvent)event));
        bus.addListener(spawn);
        if (SetupHelperImpl.hasImpl(mod, "registerCommands")) {
            Consumer<RegisterCommandsEvent> command = event -> mod.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
            forgeBus.addListener(command);
        }
        if (SetupHelperImpl.hasImpl(mod, "registerBuiltinDataPack")) {
            Consumer<AddPackFindersEvent> packFinder = event -> {
                if (event.getPackType() == PackType.SERVER_DATA) {
                    mod.registerBuiltinDataPack(packSupplier -> {
                        if (packSupplier != null) {
                            event.addRepositorySource(arg_0 -> SetupHelperImpl.lambda$deferSetup$7((Supplier)packSupplier, arg_0));
                        }
                    });
                }
            };
            bus.addListener(packFinder);
        }
        if (SetupHelperImpl.hasImpl(mod, "addLootTableInjects")) {
            Consumer<LootTableLoadEvent> lootTable = event -> mod.addLootTableInjects(new IDeferredCommonSetup.LootInjectEvent((LootTableLoadEvent)event){
                final /* synthetic */ LootTableLoadEvent val$event;
                {
                    this.val$event = lootTableLoadEvent;
                }

                @Override
                public ResourceLocation getTable() {
                    return this.val$event.getName();
                }

                @Override
                public void addTableReference(ResourceLocation injected) {
                    LootPool pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)injected)).m_79082_();
                    this.val$event.getTable().addPool(pool);
                }
            });
            forgeBus.addListener(lootTable);
        }
        if (SetupHelperImpl.hasImpl(mod, "addItemsToTabs")) {
            Consumer<BuildCreativeModeTabContentsEvent> itemsToTabs = event -> {
                IDeferredCommonSetup.ItemToTabEvent itemToTabEvent = new IDeferredCommonSetup.ItemToTabEvent((tab, target, after, items) -> {
                    if (tab != event.getTabKey()) {
                        return;
                    }
                    if (target == null) {
                        event.m_246601_(items);
                    } else {
                        MutableHashedLinkedMap entries = event.getEntries();
                        ItemStack lastValid = null;
                        for (Map.Entry e : entries) {
                            ItemStack item = (ItemStack)e.getKey();
                            if (!item.m_246617_(event.getFlags())) continue;
                            boolean isValid = target.test(item);
                            if (after.booleanValue() && lastValid != null && !isValid) {
                                List rev = Lists.reverse(new ArrayList(items));
                                for (ItemStack ni2 : rev) {
                                    entries.putAfter((Object)lastValid, (Object)ni2, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                                }
                                return;
                            }
                            if (isValid) {
                                lastValid = item;
                            }
                            if (after.booleanValue() || !isValid) continue;
                            items.forEach(ni -> entries.putBefore((Object)item, ni, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                            return;
                        }
                        for (ItemStack ni3 : items) {
                            entries.put((Object)ni3, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        }
                    }
                });
                mod.addItemsToTabs(itemToTabEvent);
            };
            FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, itemsToTabs);
        }
    }

    public static boolean hasImpl(IDeferredCommonSetup mod, String name) {
        return Utils.isMethodImplemented(IDeferredCommonSetup.class, mod.getClass(), name);
    }

    private static /* synthetic */ void lambda$deferSetup$7(Supplier packSupplier, Consumer infoConsumer) {
        infoConsumer.accept((Pack)packSupplier.get());
    }

    record PlacementEventImpl(SpawnPlacementRegisterEvent event) implements IDeferredCommonSetup.SpawnPlacementEvent
    {
        @Override
        public <T extends Entity> void register(EntityType<T> entityType, SpawnPlacements.Type decoratorType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> decoratorPredicate) {
            this.event.register(entityType, decoratorType, heightMapType, decoratorPredicate, SpawnPlacementRegisterEvent.Operation.AND);
        }
    }
}

