/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.DummyMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public final class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
extends MapDecorationType<D, M> {
    public static final Codec<CustomDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("custom_type").forGetter(MapDecorationType::getCustomFactoryID)).apply((Applicative)instance, MapDecorationRegistry::getCustomType));
    private final ResourceLocation id;
    private final BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory;
    private final Supplier<M> markerFactory;
    private final BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory;
    private final TriFunction<MapDecorationType<?, ?>, Player, MapItemSavedData, Set<D>> volatileFactory;

    public CustomDecorationType(ResourceLocation typeId, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory, @Nullable Supplier<M> markerFactory, @Nullable BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, @Nullable TriFunction<MapDecorationType<?, ?>, Player, MapItemSavedData, Set<D>> volatileFactory) {
        this.id = typeId;
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
        this.volatileFactory = volatileFactory;
    }

    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> withWorldMarker(ResourceLocation typeId, @Nullable Supplier<M> markerFactory, @Nullable BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        return new CustomDecorationType<D, M>(typeId, decorationFactory, markerFactory, markerFromWorldFactory, null);
    }

    public static <D extends CustomMapDecoration> CustomDecorationType<D, ?> simple(ResourceLocation typeId, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        return new CustomDecorationType(typeId, decorationFactory, null, null, null);
    }

    public static <D extends CustomMapDecoration> CustomDecorationType<D, ?> dynamic(ResourceLocation typeId, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory, TriFunction<MapDecorationType<?, ?>, Player, MapItemSavedData, Set<D>> volatileFactory) {
        return new CustomDecorationType(typeId, decorationFactory, null, null, volatileFactory);
    }

    @Deprecated(forRemoval=true)
    public CustomDecorationType(ResourceLocation typeId, Supplier<M> markerFactory, BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        this(typeId, decorationFactory, markerFactory, markerFromWorldFactory, null);
    }

    @Deprecated(forRemoval=true)
    public CustomDecorationType(ResourceLocation typeId, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decoFromBuffer) {
        this(typeId, null, null, decoFromBuffer);
    }

    @Override
    public ResourceLocation getCustomFactoryID() {
        return this.id;
    }

    @Override
    public boolean hasMarker() {
        return this.markerFactory != null;
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this + ": " + e);
            return null;
        }
    }

    @Override
    public Set<D> getDynamicDecorations(Player player, MapItemSavedData data) {
        if (this.volatileFactory != null) {
            return this.volatileFactory.apply(this, player, data);
        }
        return Set.of();
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(CompoundTag compound) {
        if (this.hasMarker()) {
            MapBlockMarker marker = (MapBlockMarker)this.markerFactory.get();
            try {
                marker.loadFromNBT(compound);
                return (M)marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        return (M)(this.hasMarker() ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }

    @Override
    public MapBlockMarker<D> getDefaultMarker(BlockPos pos) {
        if (this.markerFactory != null) {
            MapBlockMarker m = (MapBlockMarker)this.markerFactory.get();
            m.setPos(pos);
            return m;
        }
        return new DummyMapBlockMarker(this, pos);
    }
}

