/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.util.forge.RenderUtilImpl;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RenderUtil {
    static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderBlock(BakedModel model, long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        void var8_7;
        void var7_6;
        void var6_5;
        void var5_4;
        void var4_3;
        void var3_2;
        void var1_1;
        RenderUtilImpl.renderBlock(model, (long)var1_1, (PoseStack)var3_2, (MultiBufferSource)var4_3, (BlockState)var5_4, (Level)var6_5, (BlockPos)var7_6, (BlockRenderDispatcher)var8_7);
    }

    public static void renderBlock(long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        BakedModel model = dispatcher.m_110910_(state);
        RenderUtil.renderBlock(model, seed, poseStack, buffer, state, level, pos, dispatcher);
    }

    @Deprecated(forRemoval=true)
    public static void renderBlockModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        RenderUtil.renderModel(modelLocation, matrixStack, buffer, blockRenderer, light, overlay, cutout);
    }

    public static void renderModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        blockRenderer.m_110937_().m_111067_(matrixStack.m_85850_(), buffer.m_6299_(cutout ? Sheets.m_110790_() : Sheets.m_110789_()), null, ClientHelper.getModel(blockRenderer.m_110907_().m_110881_(), modelLocation), 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, BakedModel> movement) {
        RenderUtil.renderGuiItemRelative(poseStack, stack, x, y, renderer, movement, 0xF000F0, OverlayTexture.f_118083_);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, BakedModel> movement, int combinedLight, int pCombinedOverlay) {
        boolean flag;
        BakedModel model = renderer.m_174264_(stack, null, null, 0);
        int l = 0;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, (float)(50 + (model.m_7539_() ? l : 0)));
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 150.0f);
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        } else {
            Lighting.m_84931_();
        }
        ItemDisplayContext pTransformType = ItemDisplayContext.GUI;
        if (stack.m_150930_(Items.f_42713_)) {
            model = renderer.m_115103_().m_109393_().m_119422_(TRIDENT_MODEL);
        } else if (stack.m_150930_(Items.f_151059_)) {
            model = renderer.m_115103_().m_109393_().m_119422_(SPYGLASS_MODEL);
        }
        model = RenderUtil.handleCameraTransforms(model, poseStack, pTransformType);
        movement.accept(poseStack, model);
        RenderUtil.renderGuiItem(model, stack, renderer, combinedLight, pCombinedOverlay, poseStack, bufferSource, flag);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static BakedModel handleCameraTransforms(BakedModel model, PoseStack matrixStack, ItemDisplayContext pTransformType) {
        void var2_2;
        void var1_1;
        return RenderUtilImpl.handleCameraTransforms(model, (PoseStack)var1_1, (ItemDisplayContext)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderGuiItem(BakedModel model, ItemStack stack, ItemRenderer renderer, int combinedLight, int pCombinedOverlay, PoseStack poseStack, MultiBufferSource.BufferSource buffer, boolean flatItem) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        RenderUtilImpl.renderGuiItem(model, (ItemStack)var1_1, (ItemRenderer)var2_2, (int)var3_3, (int)var4_4, (PoseStack)var5_5, (MultiBufferSource.BufferSource)var6_6, (boolean)var7_7);
    }

    public static GuiGraphics getGuiDummy(PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        return new GuiGraphics(mc, poseStack, mc.m_91269_().m_110104_());
    }

    public static void blitSpriteSection(GuiGraphics graphics, int x, int y, int w, int h, float u, float v, int uW, int vH, TextureAtlasSprite sprite) {
        SpriteContents c = sprite.m_245424_();
        int width = (int)((float)c.m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
        int height = (int)((float)c.m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
        graphics.m_280411_(sprite.m_247685_(), x, y, w, h, sprite.m_118367_((double)u) * (float)width, (float)height * sprite.m_118393_((double)v), uW, vH, width, height);
    }

    public static RenderType getTextMipmapRenderType(ResourceLocation texture) {
        return Internal.TEXT.apply(texture);
    }

    public static RenderType getEntityCutoutMipmapRenderType(ResourceLocation texture) {
        return Internal.ENTITY_CUTOUT.apply(texture);
    }

    public static RenderType getEntitySolidMipmapRenderType(ResourceLocation texture) {
        return Internal.ENTITY_SOLID.apply(texture);
    }

    public static void setDynamicTexturesToUseMipmap(boolean mipMap) {
        MoonlightClient.setMipMap(mipMap);
    }

    private static class Internal
    extends RenderType {
        private static final Function<ResourceLocation, RenderType> TEXT = Util.m_143827_(p -> {
            RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(f_173086_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p, false, true)).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false);
            return Internal.m_173215_((String)"moonlight_text_mipped", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)compositeState);
        });
        private static final Function<ResourceLocation, RenderType> ENTITY_SOLID = Util.m_143827_(resourceLocation -> {
            RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(f_173112_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, true)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
            return Internal.m_173215_((String)"moonlight_entity_solid_mipped", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
        });
        private static final Function<ResourceLocation, RenderType> ENTITY_CUTOUT = Util.m_143827_(resourceLocation -> {
            RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(f_173113_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, true)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
            return RenderType.m_173215_((String)"moonlight_entity_cutout_mipped", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
        });

        public Internal(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

