/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookMarkRead;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.jei.PatchouliJeiPlugin;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.mixin.client.AccessorScreen;
import vazkii.patchouli.xplat.IXplatAbstractions;

public abstract class GuiBook
extends Screen {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static long lastSound;
    public int bookLeft;
    public int bookTop;
    private float scaleFactor;
    @Nullable
    private List<Component> tooltip;
    @Nullable
    private ItemStack tooltipStack;
    @Nullable
    private Pair<BookEntry, Integer> targetPage;
    protected int spread = 0;
    protected int maxSpreads = 0;
    public int ticksInBook;
    public int maxScale;
    protected boolean needsBookmarkUpdate = false;

    public GuiBook(Book book, Component title) {
        super(title);
        this.book = book;
    }

    public void m_7856_() {
        Window res = this.f_96541_.m_91268_();
        double oldGuiScale = res.m_85385_(((Integer)this.f_96541_.f_91066_.m_231928_().m_231551_()).intValue(), this.f_96541_.m_91390_());
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        double newGuiScale = res.m_85385_(persistentScale, this.f_96541_.m_91390_());
        if (persistentScale > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.m_85449_();
            res.m_85378_(newGuiScale);
            this.f_96543_ = res.m_85445_();
            this.f_96544_ = res.m_85446_();
            res.m_85378_(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.bookLeft = this.f_96543_ / 2 - 136;
        this.bookTop = this.f_96544_ / 2 - 90;
        this.book.getContents().currentGui = this;
        this.m_142416_(new GuiButtonBook(this, this.f_96543_ / 2 - 9, this.bookTop + 180 - 5, 308, 0, 18, 9, this::canSeeBackButton, this::handleButtonBack, new Component[]{Component.m_237115_((String)"patchouli.gui.lexicon.button.back"), Component.m_237115_((String)"patchouli.gui.lexicon.button.back.info").m_130940_(ChatFormatting.GRAY)}));
        this.m_142416_(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.m_142416_(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280168_().m_85836_();
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85841_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85849_();
    }

    private void drawScreenAfterScale(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.m_280273_(graphics);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85849_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        IXplatAbstractions.INSTANCE.fireDrawBookScreen(this.book.id, this, mouseX, mouseY, partialTicks, graphics);
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.removeDrawablesIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (PersistentData.Bookmark bookmark : bookmarks) {
            this.m_142416_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.m_142416_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.m_142416_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 20, MultiblockVisualizationHandler.bookmark, true));
        }
        if (this.shouldAddMarkReadButton()) {
            this.m_142416_(new GuiButtonBookMarkRead(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 10));
        }
    }

    public final void removeDrawablesIf(Predicate<Renderable> pred) {
        ((AccessorScreen)((Object)this)).getRenderables().removeIf(pred);
        this.m_6702_().removeIf(listener -> {
            Renderable w;
            return listener instanceof Renderable && pred.test(w = (Renderable)listener);
        });
        ((AccessorScreen)((Object)this)).getNarratables().removeIf(listener -> {
            Renderable w;
            return listener instanceof Renderable && pred.test(w = (Renderable)listener);
        });
    }

    public final void removeDrawablesIn(Collection<?> coll) {
        this.removeDrawablesIf(coll::contains);
    }

    public <T extends GuiEventListener & Renderable> T m_142416_(T drawableElement) {
        return (T)super.m_142416_(drawableElement);
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    protected boolean shouldAddMarkReadButton() {
        if (this instanceof GuiBookIndex) {
            return false;
        }
        return this.book.getContents().entries.values().stream().anyMatch(v -> !v.isLocked() && v.getReadState().equals((Object)EntryDisplayState.UNREAD));
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void m_86600_() {
        if (!GuiBook.m_96638_()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(graphics, this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = Screen.m_280152_((Minecraft)this.f_96541_, (ItemStack)this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.getContents().getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getFirst())) {
                MutableComponent t = Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"patchouli.gui.lexicon.shift_for_recipe")).m_130946_(")").m_130940_(ChatFormatting.GOLD);
                tooltip.add(t);
                this.targetPage = provider;
            }
            graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            graphics.m_280666_(this.f_96547_, this.tooltip, mouseX, mouseY);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(GuiGraphics graphics, Book book, int x, int y, int u, int v, int w, int h) {
        graphics.m_280163_(book.bookTexture, x, y, (float)u, (float)v, w, h, 512, 256);
    }

    public boolean m_7043_() {
        return this.book.pauseGame;
    }

    private void handleButtonBack(Button button) {
        this.back(false);
    }

    public void handleButtonArrow(Button button) {
        this.changePage(((GuiButtonBookArrow)button).left, false);
    }

    public void handleButtonBookmark(Button button) {
        GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
        PersistentData.Bookmark bookmark = bookmarkButton.bookmark;
        if (bookmark == null || bookmark.getEntry(this.book) == null) {
            this.bookmarkThis();
        } else if (GuiBook.m_96638_() && !bookmarkButton.multiblock) {
            List<PersistentData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
            bookmarks.remove(bookmark);
            PersistentData.save();
            this.needsBookmarkUpdate = true;
        } else {
            this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.spread), true);
        }
    }

    public final boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClickedScaled(mouseX / (double)this.scaleFactor, mouseY / (double)this.scaleFactor, mouseButton);
    }

    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.m_96638_()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getFirst(), (Integer)this.targetPage.getSecond()), true);
                GuiBook.playBookFlipSound(this.book);
                return true;
            }
            case 1: {
                this.back(true);
                return true;
            }
            case 3: {
                this.changePage(true, true);
                return true;
            }
            case 4: {
                this.changePage(false, true);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode) && !this.canSeeBackButton()) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 259) {
            this.back(true);
            return true;
        }
        if (this.tooltipStack != null && IXplatAbstractions.INSTANCE.handleRecipeKeybind(keyCode, scanCode, this.tooltipStack)) {
            return true;
        }
        if (this.tooltipStack != null && IXplatAbstractions.INSTANCE.isModLoaded("jei") && PatchouliJeiPlugin.handleRecipeKeybind(keyCode, scanCode, this.tooltipStack)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.changePage(false, true);
        } else if (scroll > 0.0) {
            this.changePage(true, true);
        }
        return true;
    }

    void back(boolean sfx) {
        if (!this.book.getContents().guiStack.isEmpty()) {
            if (GuiBook.m_96638_()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.getContents().guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.getContents().guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            this.spread = left ? --this.spread : ++this.spread;
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.spread > 0 : this.spread + 1 < this.maxSpreads;
    }

    public boolean canSeeBackButton() {
        return !this.book.getContents().guiStack.isEmpty();
    }

    public void setTooltip(Component ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<Component> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(ItemStack stack) {
        this.setTooltip(Collections.emptyList());
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = this.getRelativeX(absMx);
        double my = this.getRelativeY(absMy);
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void drawProgressBar(GuiGraphics graphics, Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || !book.advancementsEnabled()) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.getContents().entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        graphics.m_280509_(barLeft, barTop, barLeft + barWidth, barTop + barHeight, book.headerColor);
        this.drawGradient(graphics, barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(graphics, barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"patchouli.gui.lexicon.progress_meter"), barLeft, barTop - 9, book.headerColor, false);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            MutableComponent progressStr = Component.m_237110_((String)"patchouli.gui.lexicon.progress_tooltip", (Object[])new Object[]{unlockedEntries, totalEntries});
            tooltip.add((Component)progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add((Component)Component.m_237115_((String)"patchouli.gui.lexicon.progress_tooltip.secret1").m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"patchouli.gui.lexicon.progress_tooltip.secret", (Object[])new Object[]{unlockedSecretEntries}).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add((Component)Component.m_237115_((String)"patchouli.gui.lexicon.progress_tooltip.info").m_130940_(ChatFormatting.GRAY));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(GuiGraphics graphics, int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        graphics.m_280024_(x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(GuiGraphics graphics, FormattedCharSequence s, int x, int y, int color) {
        graphics.m_280649_(this.f_96547_, s, x - this.f_96547_.m_92724_(s) / 2, y, color, false);
    }

    public void drawCenteredStringNoShadow(GuiGraphics graphics, String s, int x, int y, int color) {
        graphics.m_280056_(this.f_96547_, s, x - this.f_96547_.m_92895_(s) / 2, y, color, false);
    }

    private int getMaxAllowedScale() {
        return this.f_96541_.m_91268_().m_85385_(0, this.f_96541_.m_91390_());
    }

    public int getSpread() {
        return this.spread;
    }

    public static void drawSeparator(GuiGraphics graphics, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.8f);
        GuiBook.drawFromTexture(graphics, book, rx, y, 140, 180, w, h);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawLock(GuiGraphics graphics, Book book, int x, int y) {
        GuiBook.drawFromTexture(graphics, book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(GuiGraphics graphics, Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        RenderSystem.enableBlend();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(graphics, book, x, y, state.u, 197, 8, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(GuiGraphics graphics, Book book) {
        GuiBook.drawPageFiller(graphics, book, 141, 18);
    }

    public static void drawPageFiller(GuiGraphics graphics, Book book, int x, int y) {
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280163_(book.fillerTexture, x + 58 - 64, y + 78 - 74, 0.0f, 0.0f, 128, 128, 128, 128);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6L) {
            SoundEvent sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.BOOK_FLIP);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(Screen prevScreen, String address) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new ConfirmLinkScreen(yes -> {
            if (yes) {
                Util.m_137581_().m_137646_(address);
            }
            mc.m_91152_(prevScreen);
        }, address, false));
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.getContents().openLexiconGui(gui, push);
    }
}

