/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContentExternalLoader;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.client.book.BookContentResourceDirectLoader;
import vazkii.patchouli.client.book.BookContentResourceListenerLoader;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookContentsBuilder {
    public static final String DEFAULT_LANG = "en_us";
    private final Map<ResourceLocation, BookCategory> categories = new HashMap<ResourceLocation, BookCategory>();
    private final Map<ResourceLocation, BookEntry> entries = new HashMap<ResourceLocation, BookEntry>();
    private final Map<ResourceLocation, Supplier<BookTemplate>> templates = new HashMap<ResourceLocation, Supplier<BookTemplate>>();
    private final Map<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>> recipeMappings = new HashMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>>();
    private final Book book;
    private final boolean singleBookReload;

    private BookContentsBuilder(Book book, boolean singleBookReload) {
        this.book = book;
        this.singleBookReload = singleBookReload;
        this.templates.putAll(BookContents.addonTemplates);
    }

    @Nullable
    public BookCategory getCategory(ResourceLocation id) {
        return this.categories.get(id);
    }

    @Nullable
    public BookEntry getEntry(ResourceLocation id) {
        return this.entries.get(id);
    }

    @Nullable
    public Supplier<BookTemplate> getTemplate(ResourceLocation id) {
        return this.templates.get(id);
    }

    public void addRecipeMapping(ItemStackUtil.StackWrapper stack, BookEntry entry, int spread) {
        this.recipeMappings.put(stack, (Pair<BookEntry, Integer>)Pair.of((Object)entry, (Object)spread));
    }

    public static BookContents loadAndBuildFor(Level level, Book book, boolean singleBookReload) {
        BookContentsBuilder builder = new BookContentsBuilder(book, singleBookReload);
        builder.loadFiles();
        return builder.build(level);
    }

    private void loadFiles() {
        this.load("categories", BookContentsBuilder::loadCategory, this.categories);
        this.load("entries", (b, l, id, file) -> BookContentsBuilder.loadEntry(b, l, id, file, this.categories::get), this.entries);
        this.load("templates", BookContentsBuilder::loadTemplate, this.templates);
    }

    private BookContents build(Level level) {
        this.categories.forEach((id, category) -> {
            try {
                category.build(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while building category " + id, e);
            }
        });
        this.entries.values().forEach(entry -> {
            try {
                entry.build(level, this);
            }
            catch (Exception e) {
                throw new RuntimeException("Error building entry " + entry.getId(), e);
            }
        });
        BookCategory pamphletCategory = null;
        if (this.book.isPamphlet) {
            if (this.categories.size() != 1) {
                throw new RuntimeException("A pamphlet should have exactly one category but instead there were " + this.categories.size());
            }
            pamphletCategory = this.categories.values().iterator().next();
        }
        return new BookContents(this.book, (ImmutableMap<ResourceLocation, BookCategory>)ImmutableMap.copyOf(this.categories), (ImmutableMap<ResourceLocation, BookEntry>)ImmutableMap.copyOf(this.entries), (ImmutableMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>>)ImmutableMap.copyOf(this.recipeMappings), pamphletCategory);
    }

    private <T> void load(String thing, LoadFunc<T> loader, Map<ResourceLocation, T> builder) {
        BookContentLoader contentLoader = this.getContentLoader();
        ArrayList<ResourceLocation> foundIds = new ArrayList<ResourceLocation>();
        contentLoader.findFiles(this.book, thing, foundIds);
        for (ResourceLocation id : foundIds) {
            String filePath = String.format("%s/%s/%s/%s/%s.json", "patchouli_books", this.book.id.m_135815_(), DEFAULT_LANG, thing, id.m_135815_());
            T value = loader.load(this.book, contentLoader, id, new ResourceLocation(id.m_135827_(), filePath));
            if (value == null) continue;
            builder.put(id, value);
        }
    }

    protected BookContentLoader getContentLoader() {
        if (this.book.isExternal) {
            return BookContentExternalLoader.INSTANCE;
        }
        return this.singleBookReload ? BookContentResourceDirectLoader.INSTANCE : BookContentResourceListenerLoader.INSTANCE;
    }

    @Nullable
    private static BookCategory loadCategory(Book book, BookContentLoader loader, ResourceLocation id, ResourceLocation file) {
        BookContentLoader.LoadResult result = BookContentsBuilder.loadLocalizedJson(book, loader, file);
        BookCategory category = new BookCategory(result.json().getAsJsonObject(), id, book);
        if (category.canAdd()) {
            return category;
        }
        return null;
    }

    @Nullable
    private static BookEntry loadEntry(Book book, BookContentLoader loader, ResourceLocation id, ResourceLocation file, Function<ResourceLocation, BookCategory> categories) {
        BookContentLoader.LoadResult result = BookContentsBuilder.loadLocalizedJson(book, loader, file);
        BookEntry entry = new BookEntry(result.json().getAsJsonObject(), id, book, result.addedBy());
        if (entry.canAdd()) {
            entry.initCategory(file, categories);
            return entry;
        }
        return null;
    }

    private static Supplier<BookTemplate> loadTemplate(Book book, BookContentLoader loader, ResourceLocation key, ResourceLocation res) {
        JsonElement json = BookContentsBuilder.loadLocalizedJson(book, loader, res).json();
        Supplier<BookTemplate> supplier = () -> (BookTemplate)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookTemplate.class);
        BookTemplate template = supplier.get();
        if (template == null) {
            throw new IllegalArgumentException(res + " could not be instantiated by the supplier.");
        }
        return supplier;
    }

    private static BookContentLoader.LoadResult loadLocalizedJson(Book book, BookContentLoader loader, ResourceLocation file) {
        ResourceLocation localizedFile = new ResourceLocation(file.m_135827_(), file.m_135815_().replaceAll(DEFAULT_LANG, ClientBookRegistry.INSTANCE.currentLang));
        BookContentLoader.LoadResult input = loader.loadJson(book, localizedFile);
        if (input == null && (input = loader.loadJson(book, file)) == null) {
            throw new IllegalArgumentException(file + " does not exist.");
        }
        return input;
    }

    private static interface LoadFunc<T> {
        @Nullable
        public T load(Book var1, BookContentLoader var2, ResourceLocation var3, ResourceLocation var4);
    }
}

