/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato;

import com.google.common.collect.Lists;
import com.tarinoita.solsweetpotato.tracking.CapabilityHandler;
import com.tarinoita.solsweetpotato.tracking.benefits.BenefitsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="solapplepie")
public final class SOLSweetPotatoConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private static String localizationPath(String path) {
        return "config.solapplepie." + path;
    }

    public static void setUp() {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        PlayerList players = currentServer.m_6846_();
        for (Player player : players.m_11314_()) {
            BenefitsHandler.removeAllBenefits(player);
            BenefitsHandler.updatePlayer(player);
            CapabilityHandler.syncFoodList(player);
        }
    }

    public static List<String> getBlacklist() {
        return new ArrayList<String>((Collection)SOLSweetPotatoConfig.SERVER.blacklist.get());
    }

    public static List<String> getWhitelist() {
        return new ArrayList<String>((Collection)SOLSweetPotatoConfig.SERVER.whitelist.get());
    }

    public static List<String> getBenefitsUnparsed() {
        return new ArrayList<String>((Collection)SOLSweetPotatoConfig.SERVER.benefitsUnparsed.get());
    }

    public static List<String> getComplexityUnparsed() {
        return new ArrayList<String>((Collection)SOLSweetPotatoConfig.SERVER.complexityUnparsed.get());
    }

    public static List<Double> getThresholds() {
        return new ArrayList<Double>((Collection)SOLSweetPotatoConfig.SERVER.thresholds.get());
    }

    public static boolean shouldResetOnDeath() {
        return (Boolean)SOLSweetPotatoConfig.SERVER.shouldResetOnDeath.get();
    }

    public static boolean limitProgressionToSurvival() {
        return (Boolean)SOLSweetPotatoConfig.SERVER.limitProgressionToSurvival.get();
    }

    public static boolean shouldForbiddenCount() {
        return (Boolean)SOLSweetPotatoConfig.SERVER.shouldForbiddenCount.get();
    }

    public static Integer size() {
        return (Integer)SOLSweetPotatoConfig.SERVER.queueSize.get();
    }

    public static Integer endDecay() {
        return (Integer)SOLSweetPotatoConfig.SERVER.endDecay.get();
    }

    public static Integer startDecay() {
        return (Integer)SOLSweetPotatoConfig.SERVER.startDecay.get();
    }

    public static Double minContribution() {
        return (Double)SOLSweetPotatoConfig.SERVER.minContribution.get();
    }

    public static Double defaultContribution() {
        return (Double)SOLSweetPotatoConfig.SERVER.defaultContribution.get();
    }

    public static Integer minFoodsToActivate() {
        return (Integer)SOLSweetPotatoConfig.SERVER.minFoodsToActivate.get();
    }

    public static boolean isFoodTooltipEnabled() {
        return (Boolean)SOLSweetPotatoConfig.CLIENT.isFoodTooltipEnabled.get();
    }

    public static boolean shouldShowInactiveBenefits() {
        return (Boolean)SOLSweetPotatoConfig.CLIENT.shouldShowInactiveBenefits.get();
    }

    public static boolean hasWhitelist() {
        return !((List)SOLSweetPotatoConfig.SERVER.whitelist.get()).isEmpty();
    }

    public static boolean isAllowed(Item food) {
        String id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)food)).toString();
        if (SOLSweetPotatoConfig.hasWhitelist()) {
            return SOLSweetPotatoConfig.matchesAnyPattern(id, (Collection)SOLSweetPotatoConfig.SERVER.whitelist.get());
        }
        return !SOLSweetPotatoConfig.matchesAnyPattern(id, (Collection)SOLSweetPotatoConfig.SERVER.blacklist.get());
    }

    public static boolean shouldCount(Item food) {
        return SOLSweetPotatoConfig.isAllowed(food);
    }

    private static boolean matchesAnyPattern(String query, Collection<? extends String> patterns) {
        for (String string : patterns) {
            StringBuilder pattern = new StringBuilder(string.length());
            for (String part : string.split("\\*", -1)) {
                if (!part.isEmpty()) {
                    pattern.append(Pattern.quote(part));
                }
                pattern.append(".*");
            }
            pattern.delete(pattern.length() - 2, pattern.length());
            if (!Pattern.matches(pattern.toString(), query)) continue;
            return true;
        }
        return false;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)specPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.IntValue queueSize;
        public final ForgeConfigSpec.BooleanValue shouldResetOnDeath;
        public final ForgeConfigSpec.BooleanValue limitProgressionToSurvival;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> thresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> benefitsUnparsed;
        public final ForgeConfigSpec.IntValue minFoodsToActivate;
        public final ForgeConfigSpec.DoubleValue minContribution;
        public final ForgeConfigSpec.DoubleValue defaultContribution;
        public final ForgeConfigSpec.IntValue endDecay;
        public final ForgeConfigSpec.IntValue startDecay;
        public final ForgeConfigSpec.BooleanValue shouldForbiddenCount;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> complexityUnparsed;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Benefits");
            this.thresholds = builder.translation(SOLSweetPotatoConfig.localizationPath("thresholds")).comment(" A list of diversity value thresholds, in ascending order. When the player's food diversity reaches a threshold,\n they will get the benefits associated with that threshold.\n\n").defineList("thresholds", (List)Lists.newArrayList((Object[])new Double[]{2.0, 5.0, 7.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0}), e -> e instanceof Double);
            this.benefitsUnparsed = builder.translation(SOLSweetPotatoConfig.localizationPath("benefits_unparsed")).comment(" \n Define custom benefits here. Each entry in the list corresponds to a benefit that will be obtained\n at the corresponding diversity threshold defined the list above. For example, the first entry in\n this list will be applied when the player's food diversity reaches the number in the first entry in\n the threshold list above.\n A benefit can also be marked as a detriment. In that case, its activation is reversed.\n A detriment is applied while the player has less diversity than the threshold,\n and will be removed when the threshold is reached.\n Each benefit is a string with the following form: [+/-][type],[registry name],[value] (without the brackets)\n A leading plus (or the of a symbol) denotes a benefit, while a minus denotes a detriment.\n The type can either be 'attribute' for attribute modifiers or 'effect' for potion effects\n Registry names for common vanila attributes are \n generic.max_health, generic.knockback_resistance, generic.movement_speed, generic.luck, \n generic.attack_damage, generic.attack_speed, generic.armor, generic.armor_toughness \n The value of attributes is the numerical number that will be added to that attribute\n Use a negative number for subtraction. Multiplicative modifiers are not supported.\n For potion effects, the value is an integer and is the potion effect amplifier. Note\n that the amplifier is 0 indexed, so minecraft:strength,1 corresponds to Strength II\n\n To add multiple benefits to the same threshold, separate them by a semicolon ';'\n Make sure that you have NO SPACES!\n As an example, 'attribute,generic.max_health,2;effect,strength,1' will give both +2 max hp\n and Strength II at the corresponding threshold.\n 'attribute,generic.attack_damage,1;-effect,slowness,0' will give +1 attack damage at the corresponding threshold\n and Slowness I below the corresponding threshold.\n\n").defineList("benefitsUnparsed", (List)Lists.newArrayList((Object[])new String[]{"effect,speed,0", "attribute,generic.max_health,1", "attribute,generic.max_health,1;effect,haste,0", "attribute,generic.max_health,1;effect,strength,0", "attribute,generic.max_health,1;attribute,generic.armor_toughness,2", "attribute,generic.max_health,1;effect,regeneration,0", "attribute,generic.max_health,1;effect,speed,1", "attribute,generic.max_health,1;effect,strength,0", "attribute,generic.max_health,1;effect,luck,0", "attribute,generic.max_health,1;attribute,generic.knockback_resistance,1", "attribute,generic.max_health,1;attribute,generic.speed,2", "attribute,generic.max_health,1;attribute,generic.armor_toughness,2", "attribute,generic.max_health,1;effect,haste,1", "attribute,generic.max_health,1;effect,strength,1", "attribute,generic.max_health,1;attribute,generic.armor_toughness,2", "attribute,generic.max_health,1;effect,strength,2", "attribute,generic.max_health,1;effect,luck,1"}), e -> e instanceof String);
            this.minFoodsToActivate = builder.translation(SOLSweetPotatoConfig.localizationPath("min_foods_to_activate")).comment(" The minimum number of foods a player needs to eat before any benefits are applied.\n\n").defineInRange("minFoodsToActivate", 0, 0, 1000);
            builder.pop();
            builder.push("Filtering");
            this.blacklist = builder.translation(SOLSweetPotatoConfig.localizationPath("blacklist")).comment(" Foods in this list won't contribute to food diversity.\n\n").defineList("blacklist", (List)Lists.newArrayList(), e -> e instanceof String);
            this.whitelist = builder.translation(SOLSweetPotatoConfig.localizationPath("whitelist")).comment("\n When this list contains anything, the blacklist is ignored and instead only foods from here count.\n\n").defineList("whitelist", (List)Lists.newArrayList(), e -> e instanceof String);
            builder.pop();
            builder.push("Miscellaneous");
            this.shouldResetOnDeath = builder.translation(SOLSweetPotatoConfig.localizationPath("reset_on_death")).comment(" Whether or not to reset food diversity on death, effectively losing all benefits.\n\n").define("resetOnDeath", false);
            this.limitProgressionToSurvival = builder.translation(SOLSweetPotatoConfig.localizationPath("limit_progression_to_survival")).comment("\n If true, eating foods outside of survival mode (e.g. creative/adventure) is not tracked.\n\n").define("limitProgressionToSurvival", false);
            this.queueSize = builder.translation(SOLSweetPotatoConfig.localizationPath("queue_size")).comment("\n How many foods should be tracked. I.e., how many food items eaten in the past should count toward food diversity.\n Note that the larger this is, the higher your potential diversity value can be, so keep this mind\n if you are defining custom thresholds/benefits above.\n !!!If you update queueSize, and leave the other advanced options unchanged,\n make sure you change endDecay (below) to match queueSize, or else nothing will change!!!\n\n").defineInRange("queueSize", 32, 1, 1000);
            builder.pop();
            builder.push("Advanced");
            this.minContribution = builder.translation(SOLSweetPotatoConfig.localizationPath("min_contribution")).comment(" These config options all affect the technical details of how diversity is calculated.\n Please look at the explanation on the wiki on the github to see how these values work.\n\n Lowest possible diversity contribution a food can give. This is a multiplier, not an\n absolute value!\n\n").defineInRange("minContribution", 0.0, 0.0, 1.0);
            this.defaultContribution = builder.translation(SOLSweetPotatoConfig.localizationPath("default_contribution")).comment("\n The default diversity value when you eat a food. There is little reason to ever change this.\n\n").defineInRange("defaultContribution", 1.0, 0.0, 100.0);
            this.endDecay = builder.translation(SOLSweetPotatoConfig.localizationPath("end_decay")).comment("\n How many meals in the past should the diversity penalty stop from.\n **Needs to be less than queueSize and greater than startDecay!!!**\n Note that if you update queueSize, to retain the default behavior, you need to also\n set endDecay equal to the queueSize\n\n").defineInRange("endDecay", 32, 0, 1000);
            this.startDecay = builder.translation(SOLSweetPotatoConfig.localizationPath("start_decay")).comment("\n How many meals in the past should the diversity time penalty start to apply.\n **Needs to be less than queueSize and less than or equal to endDecay!!!**\n\n").defineInRange("startDecay", 0, 0, 1000);
            this.shouldForbiddenCount = builder.translation(SOLSweetPotatoConfig.localizationPath("should_forbidden_count")).comment("\n Whether blacklisted foods should still take a spot in the queue, even if they don't contribute any diversity.\n\n").define("shouldForbiddenCount", true);
            builder.pop();
            builder.push("Complexity");
            this.complexityUnparsed = builder.translation(SOLSweetPotatoConfig.localizationPath("complexity_unparsed")).comment(" Define custom complexity values for individual foods here.\n The complexity value of a food is how much diversity points it gives. \n The base diversity value of foods not defined here is equal to defaultContribution.\n Each entry in the list should be a string defining one food, and the format is [registry name],[value]\n Note that tags are NOT currently supported.\n\n").defineList("complexityUnparsed", (List)Lists.newArrayList((Object[])new String[]{"minecraft:cooked_porkchop,2", "minecraft:cooked_beef,2", "minecraft:golden_carrot,2", "minecraft:golden_apple,4", "minecraft:enchanted_golden_apple,10", "largemeals:sweet_berry_custard,5", "largemeals:pufferfish_broth,5", "largemeals:mushroom_pot_pie,5", "largemeals:hearty_lunch,6", "farmersrespite:green_tea,3", "farmersrespite:yellow_tea,3", "farmersrespite:coffee,3", "farmersrespite:black_tea,3", "farmersrespite:rose_hip_tea,3", "farmersrespite:dandelion_tea,3", "farmersrespite:black_tea,3", "farmersrespite:rose_hip_pie_slice,4", "farmersrespite:coffee_cake_slice,4", "farmersrespite:blazing_chili,5", "farmersdelight:cake_slice,4", "farmersdelight:chocolate_pie_slice,4", "farmersdelight:apple_pie_slice,4", "farmersdelight:sweet_berry_cheesecake_slice,4"}), e -> e instanceof String);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue isFoodTooltipEnabled;
        public final ForgeConfigSpec.BooleanValue shouldShowInactiveBenefits;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("miscellaneous");
            this.isFoodTooltipEnabled = builder.translation(SOLSweetPotatoConfig.localizationPath("is_food_tooltip_enabled")).comment(" If true, foods indicate in their tooltips the last time they've been eaten, and their current diversity contribution.\n").define("isFoodTooltipEnabled", true);
            this.shouldShowInactiveBenefits = builder.translation(SOLSweetPotatoConfig.localizationPath("should_show_inactive_benefits")).comment("\n If true, the food book lists benefits that you haven't acquired yet, in addition to the ones you have.\n\n").define("shouldShowInactiveBenefits", true);
            builder.pop();
        }
    }
}

