/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerGenerator;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class GuiGenerator
extends ScreenBase<ContainerGenerator> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_generator.png");
    private Inventory playerInv;
    private TileEntityGenerator tile;

    public GuiGenerator(ContainerGenerator containerGenerator, Inventory playerInv, Component title) {
        super(GUI_TEXTURE, containerGenerator, playerInv, title);
        this.playerInv = playerInv;
        this.tile = containerGenerator.getGenerator();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.tile.m_5446_().m_7532_(), 62, 6, 0x404040, false);
        if (mouseX >= this.f_97735_ + 122 && mouseX <= this.f_97735_ + 16 + 122 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.energy", (Object[])new Object[]{this.tile.getStoredEnergy()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 39 && mouseX <= this.f_97735_ + 16 + 39 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.fuel", (Object[])new Object[]{this.tile.getCurrentMillibuckets()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawEnergy(guiGraphics);
        this.drawFluid(guiGraphics);
    }

    public void drawEnergy(GuiGraphics guiGraphics) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid(GuiGraphics guiGraphics) {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 39;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.maxMillibuckets;
    }
}

