/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public abstract class EntityCarTemperatureBase
extends EntityCarBase {
    private static final EntityDataAccessor<Float> TEMPERATURE = SynchedEntityData.m_135353_(EntityCarTemperatureBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public EntityCarTemperatureBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        float tempToReach;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        float speedPerc = this.getSpeed() / this.getMaxSpeed();
        int tempRate = (int)(speedPerc * 10.0f) + 1;
        if (tempRate > 5) {
            tempRate = 5;
        }
        float rate = (float)tempRate * 0.2f + (this.f_19796_.m_188501_() - 0.5f) * 0.1f;
        float temp = this.getTemperature();
        if (MathUtils.isInBounds(temp, tempToReach = this.getTemperatureToReach(), rate)) {
            this.setTemperature(tempToReach);
        } else {
            if (tempToReach < temp) {
                rate = -rate;
            }
            this.setTemperature(temp + rate);
        }
    }

    public float getTemperatureToReach() {
        float biomeTemp = this.getBiomeTemperatureCelsius();
        if (!this.isStarted()) {
            return biomeTemp;
        }
        float optimalTemp = this.getOptimalTemperature();
        if (biomeTemp > 45.0f) {
            optimalTemp = 100.0f;
        } else if (biomeTemp <= 0.0f) {
            optimalTemp = 80.0f;
        }
        return Math.max(biomeTemp, optimalTemp);
    }

    public float getBiomeTemperatureCelsius() {
        return (((Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_47505_(this.m_20183_()) - 0.3f) * 30.0f;
    }

    public float getTemperature() {
        return ((Float)this.f_19804_.m_135370_(TEMPERATURE)).floatValue();
    }

    public void setTemperature(float temperature) {
        this.f_19804_.m_135381_(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public abstract float getOptimalTemperature();

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEMPERATURE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTemperature(compound.m_128457_("temperature"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("temperature", this.getTemperature());
    }

    public void initTemperature() {
        this.setTemperature(this.getBiomeTemperatureCelsius());
    }
}

