/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.items.ItemRepairTool;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class EntityCarDamageBase
extends EntityCarBatteryBase {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityCarDamageBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private long lastDamage;

    public EntityCarDamageBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_()) {
            this.addDamage(1.0f);
        }
        if (this.isStarted() || this.getDamage() > 99.0f) {
            this.particles();
        }
    }

    public void particles() {
        int amount;
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (this.getDamage() < 50.0f) {
            return;
        }
        int damage = (int)this.getDamage();
        if (damage < 70) {
            if (this.f_19796_.m_188503_(10) != 0) {
                return;
            }
            amount = 1;
        } else if (damage < 80) {
            if (this.f_19796_.m_188503_(5) != 0) {
                return;
            }
            amount = 1;
        } else {
            amount = damage < 90 ? 2 : 3;
        }
        for (int i = 0; i < amount; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * this.getCarWidth(), this.m_20186_() + this.f_19796_.m_188500_() * this.getCarHeight(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * this.getCarWidth(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onCollision(float speed) {
        super.onCollision(speed);
        float percSpeed = speed / this.getMaxSpeed();
        if (percSpeed > 0.8f) {
            this.addDamage(percSpeed * 5.0f);
            this.playCrashSound();
            if (percSpeed > 0.9f) {
                this.setStarted(false);
                this.playStopSound();
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_20147_()) {
            return false;
        }
        if (this.m_9236_().f_46443_ || !this.m_6084_()) {
            return false;
        }
        if (!(source.m_7640_() instanceof Player)) {
            return false;
        }
        Player player = (Player)source.m_7640_();
        if (player == null) {
            return false;
        }
        if (player.equals((Object)this.getDriver())) {
            return false;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof ItemRepairTool) {
            long time = player.m_9236_().m_46467_();
            if (time - this.lastDamage < 10L) {
                this.destroyCar(player, true);
                stack.m_41622_(50, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(InteractionHand.MAIN_HAND));
            } else {
                this.lastDamage = time;
            }
            return true;
        }
        return false;
    }

    public void addDamage(float val) {
        this.setDamage(this.getDamage() + val);
    }

    @Override
    public boolean canStartCarEngine(Player player) {
        boolean b = true;
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canStartCarEngine(player) && b;
    }

    @Override
    public int getTimeToStart() {
        int value = super.getTimeToStart();
        if (this.getDamage() >= 95.0f) {
            value += this.f_19796_.m_188503_(25) + 50;
        } else if (this.getDamage() >= 90.0f) {
            value += this.f_19796_.m_188503_(15) + 30;
        } else if (this.getDamage() >= 80.0f) {
            value += this.f_19796_.m_188503_(15) + 10;
        } else if (this.getDamage() >= 50.0f) {
            value += this.f_19796_.m_188503_(10) + 5;
        }
        return value;
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.m_20069_()) {
            this.addDamage(25.0f);
            return false;
        }
        if (this.m_20077_()) {
            return false;
        }
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float damage) {
        if (damage > 100.0f) {
            damage = 100.0f;
        } else if (damage < 0.0f) {
            damage = 0.0f;
        }
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("damage", this.getDamage());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128457_("damage"));
    }
}

