/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityCarTemperatureBase;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopStarting;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityCarBatteryBase
extends EntityCarTemperatureBase {
    private static final EntityDataAccessor<Integer> BATTERY_LEVEL = SynchedEntityData.m_135353_(EntityCarBatteryBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STARTING_TIME = SynchedEntityData.m_135353_(EntityCarBatteryBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STARTING = SynchedEntityData.m_135353_(EntityCarBatteryBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStarting startingLoop;
    private boolean carStopped;
    private boolean carStarted;
    private int timeSinceStarted;
    private int timeToStart;

    public EntityCarBatteryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        int time;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.isStarted()) {
                ++this.timeSinceStarted;
                if (this.f_19797_ % 2 == 0) {
                    this.spawnParticles(this.getSpeed() > 0.1f);
                }
            } else {
                this.timeSinceStarted = 0;
            }
            return;
        }
        if (this.isStarting()) {
            if (this.f_19797_ % 2 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() - this.getBatteryUsage());
            }
            this.setStartingTime(this.getStartingTime() + 1);
            if (this.getBatteryLevel() <= 0) {
                this.setStarting(false, true);
            }
        } else {
            this.setStartingTime(0);
        }
        if ((time = this.getStartingTime()) > 0) {
            if (this.timeToStart <= 0) {
                this.timeToStart = this.getTimeToStart();
            }
            if (time > this.getTimeToStart()) {
                this.startCarEngine();
                this.timeToStart = 0;
            }
        }
        if (this.isStarted()) {
            this.setStartingTime(0);
            this.carStarted = true;
            float speedPerc = this.getSpeed() / this.getMaxSpeed();
            int chargingRate = (int)(speedPerc * 7.0f);
            if (chargingRate < 5) {
                chargingRate = 1;
            }
            if (this.f_19797_ % 20 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() + chargingRate);
            }
        }
    }

    public void spawnParticles(boolean driving) {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Vec3 lookVec = this.m_20154_().m_82541_();
        double offX = lookVec.f_82479_ * -1.0;
        double offY = lookVec.f_82480_;
        double offZ = lookVec.f_82481_ * -1.0;
        if (this.timeSinceStarted > 0 && this.timeSinceStarted < 20 && this.getTemperature() < 50.0f) {
            double speedX = lookVec.f_82479_ * -0.1;
            double speedZ = lookVec.f_82481_ * -0.1;
            if (this instanceof EntityCarDamageBase) {
                float damage = ((EntityCarDamageBase)this).getDamage();
                int count = 1;
                double r = 0.1;
                if (damage > 0.9f) {
                    count = 6;
                    r = 0.7;
                } else if (damage > 0.75f) {
                    count = 3;
                    r = 0.7;
                } else if (damage > 0.5f) {
                    count = 2;
                    r = 0.3;
                }
                for (int i = 0; i <= count; ++i) {
                    this.spawnParticle((ParticleOptions)ParticleTypes.f_123755_, offX, offY, offZ, speedX, speedZ, r);
                }
            } else {
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123755_, offX, offY, offZ, speedX, speedZ);
            }
        } else if (driving) {
            double speedX = lookVec.f_82479_ * -0.2;
            double speedZ = lookVec.f_82481_ * -0.2;
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123762_, offX, offY, offZ, speedX, speedZ);
        } else {
            double speedX = lookVec.f_82479_ * -0.05;
            double speedZ = lookVec.f_82481_ * -0.05;
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123762_, offX, offY, offZ, speedX, speedZ);
        }
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double speedX, double speedZ, double r) {
        this.m_9236_().m_7106_(particleTypes, this.m_20185_() + offX + (this.f_19796_.m_188500_() * r - r / 2.0), this.m_20186_() + offY + (this.f_19796_.m_188500_() * r - r / 2.0) + this.getCarHeight() / 8.0, this.m_20189_() + offZ + (this.f_19796_.m_188500_() * r - r / 2.0), speedX, 0.0, speedZ);
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double speedX, double speedZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, speedX, speedZ, 0.1);
    }

    public int getTimeToStart() {
        int time = this.f_19796_.m_188503_(10) + 5;
        float temp = this.getTemperature();
        if (temp < 0.0f) {
            time += 40;
        } else if (temp < 10.0f) {
            time += 35;
        } else if (temp < 30.0f) {
            time += 10;
        } else if (temp < 60.0f) {
            time += 5;
        }
        float batteryPerc = this.getBatteryPercentage();
        if (batteryPerc < 0.5f) {
            time += 20 + this.f_19796_.m_188503_(10);
        } else if (batteryPerc < 0.75f) {
            time += 10 + this.f_19796_.m_188503_(10);
        }
        return time;
    }

    public int getBatteryUsage() {
        if (!((Boolean)Main.SERVER_CONFIG.useBattery.get()).booleanValue()) {
            return 0;
        }
        float temp = this.getBiomeTemperatureCelsius();
        int baseUsage = 2;
        if (temp < 0.0f) {
            baseUsage += 2;
        } else if (temp < 15.0f) {
            ++baseUsage;
        }
        return baseUsage;
    }

    @Override
    public void setStarted(boolean started) {
        this.setStarting(false, false);
        super.setStarted(started);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BATTERY_LEVEL, (Object)this.getMaxBatteryLevel());
        this.f_19804_.m_135372_(STARTING_TIME, (Object)0);
        this.f_19804_.m_135372_(STARTING, (Object)Boolean.FALSE);
    }

    public int getStartingTime() {
        return (Integer)this.f_19804_.m_135370_(STARTING_TIME);
    }

    public void setStartingTime(int time) {
        this.f_19804_.m_135381_(STARTING_TIME, (Object)time);
    }

    public boolean isStarting() {
        return (Boolean)this.f_19804_.m_135370_(STARTING);
    }

    public void setStarting(boolean starting, boolean playFailSound) {
        if (starting) {
            if (this.getBatteryLevel() <= 0) {
                return;
            }
            if (this.isStarted()) {
                this.setStarted(false, true, false);
                this.carStopped = true;
                return;
            }
        } else {
            if (this.carStarted || this.carStopped) {
                this.carStopped = false;
                this.carStarted = false;
                return;
            }
            if (playFailSound && this.getBatteryLevel() > 0) {
                this.playFailSound();
            }
        }
        this.f_19804_.m_135381_(STARTING, (Object)starting);
    }

    public float getBatterySoundPitchLevel() {
        int batteryLevel = this.getBatteryLevel();
        int startLevel = this.getMaxBatteryLevel() / 3;
        float basePitch = 1.0f - 0.002f * (float)this.getStartingTime();
        if (batteryLevel > startLevel) {
            return basePitch;
        }
        int levelUnder = startLevel - batteryLevel;
        float perc = (float)levelUnder / (float)startLevel;
        return basePitch - perc / 2.3f;
    }

    public float getBatteryPercentage() {
        return (float)this.getBatteryLevel() / (float)this.getMaxBatteryLevel();
    }

    public void setBatteryLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level > this.getMaxBatteryLevel()) {
            level = this.getMaxBatteryLevel();
        }
        this.f_19804_.m_135381_(BATTERY_LEVEL, (Object)level);
    }

    public int getBatteryLevel() {
        return (Integer)this.f_19804_.m_135370_(BATTERY_LEVEL);
    }

    public int getMaxBatteryLevel() {
        return 1000;
    }

    @Override
    public void updateSounds() {
        if (!this.isStarted() && this.isStarting()) {
            this.checkStartingLoop();
        }
        super.updateSounds();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBatteryLevel(compound.m_128451_("battery"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("battery", this.getBatteryLevel());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartingLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this, this.getStartingSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.startingLoop, this.m_9236_());
        }
    }

    @Override
    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.m_9236_(), this.m_20183_(), null, SoundSource.MASTER, 1.0f, this.getBatterySoundPitchLevel());
    }
}

