/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen.mixin;

import com.minenash.seamless_loading_screen.FadeScreen;
import com.minenash.seamless_loading_screen.OnLeaveHelper;
import com.minenash.seamless_loading_screen.ScreenshotLoader;
import com.minenash.seamless_loading_screen.SeamlessLoadingScreen;
import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=900)
public abstract class MinecraftClientMixin {
    @Shadow
    static Minecraft f_90981_;
    @Shadow
    @Nullable
    public Screen f_91080_;
    @Shadow
    @Nullable
    public ClientLevel f_91073_;
    @Shadow
    @Final
    private static Logger f_90982_;
    @Unique
    private boolean terrainScreenReplaced = false;
    @Unique
    private boolean firstOccurrence = true;
    @Shadow
    @Final
    private Window f_90990_;

    @Shadow
    public abstract void m_91395_();

    @Shadow
    public abstract void m_91152_(@Nullable Screen var1);

    @Inject(method={"joinWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;reset(Lnet/minecraft/client/gui/screen/Screen;)V")})
    private void changeScreen(ClientLevel world, CallbackInfo ci) {
        if (SeamlessLoadingScreen.changeWorldJoinScreen) {
            SeamlessLoadingScreen.changeWorldJoinScreen = false;
            ScreenshotLoader.inFade = true;
            this.terrainScreenReplaced = false;
        }
    }

    @ModifyVariable(method={"setScreen"}, at=@At(value="HEAD"), argsOnly=true, index=1)
    private Screen fadeScreen(Screen screen) {
        if (this.f_91080_ instanceof ReceivingLevelScreen && this.f_91073_ != null && ScreenshotLoader.loaded && ScreenshotLoader.inFade) {
            if (screen == null) {
                this.terrainScreenReplaced = true;
                return new FadeScreen(Config.get().time, Config.get().fade).then(forced -> {
                    if (!forced.booleanValue()) {
                        this.m_91152_(null);
                    }
                    ScreenshotLoader.inFade = false;
                });
            }
            f_90982_.warn("[SeamlessLoadingScreen] Fade screen has been skipped due to someone replacing the screen before we could add our own after DownloadingTerrainScreen");
            ScreenshotLoader.inFade = false;
            ScreenshotLoader.replacebg = false;
        }
        return screen;
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")})
    private void failSafe(Screen screen, CallbackInfo ci) {
        if (this.terrainScreenReplaced && !(screen instanceof FadeScreen) || screen == null && (ScreenshotLoader.inFade || ScreenshotLoader.replacebg)) {
            ScreenshotLoader.inFade = false;
            ScreenshotLoader.replacebg = false;
            this.terrainScreenReplaced = false;
        }
    }

    @Inject(method={"scheduleStop"}, at={@At(value="HEAD")}, cancellable=true)
    private void onWindowClose(CallbackInfo info) {
        if (!this.firstOccurrence || MinecraftClientMixin.f_90981_.f_91074_ == null) {
            return;
        }
        OnLeaveHelper.beginScreenshotTask(() -> {
            this.firstOccurrence = false;
            this.m_91395_();
        });
        info.cancel();
    }

    @Inject(method={"onResolutionChanged"}, at={@At(value="TAIL")})
    private void captureResize(CallbackInfo ci) {
        if (SeamlessLoadingScreen.BLUR_PROGRAM.loaded) {
            SeamlessLoadingScreen.BLUR_PROGRAM.onWindowResize((Minecraft)this, this.f_90990_);
        }
    }
}

