/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TimeUtil {
    public static final long DURATION_SECOND = 1000L;
    public static final long DURATION_MINUTE = 60000L;
    public static final long DURATION_HOUR = 3600000L;
    public static final long DURATION_DAY = 86400000L;

    public static long getCurrentTime() {
        return System.currentTimeMillis() + LightmansCurrency.PROXY.getTimeDesync();
    }

    public static String formatTime(long timeStamp) {
        return new SimpleDateFormat((String)Config.CLIENT.timeFormat.get()).format(new Date(timeStamp - LightmansCurrency.PROXY.getTimeDesync()));
    }

    public static boolean compareTime(long duration, long compareTime) {
        long ignoreTime = TimeUtil.getCurrentTime() - duration;
        return compareTime >= ignoreTime;
    }

    public static long getDuration(long days, long hours, long minutes, long seconds) {
        days = Math.max(days, 0L);
        hours = Math.max(hours, 0L);
        minutes = Math.max(minutes, 0L);
        seconds = Math.max(seconds, 0L);
        return (seconds += 60L * (minutes += 60L * (hours += 24L * days))) * 1000L;
    }

    @Deprecated(forRemoval=true)
    public static TimeData separateDuration(long duration) {
        return new TimeData(duration);
    }

    public static class TimeData {
        public final long days;
        public final long hours;
        public final long minutes;
        public final long seconds;
        public final long miliseconds;

        public TimeData(long days, long hours, long minutes, long seconds) {
            this(TimeUtil.getDuration(days, hours, minutes, seconds));
        }

        public TimeData(long milliseconds) {
            this.miliseconds = Math.max(milliseconds, 0L);
            long seconds = this.miliseconds / 1000L;
            long minutes = seconds / 60L;
            seconds %= 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            this.days = days;
            this.hours = hours %= 24L;
            this.minutes = minutes %= 60L;
            this.seconds = seconds;
        }

        private long getUnitValue(TimeUnit unit) {
            return switch (unit) {
                default -> throw new IncompatibleClassChangeError();
                case TimeUnit.DAY -> this.days;
                case TimeUnit.HOUR -> this.hours;
                case TimeUnit.MINUTE -> this.minutes;
                case TimeUnit.SECOND -> this.seconds;
            };
        }

        public String getUnitString(TimeUnit unit, boolean shortText) {
            return this.getUnitString(unit, shortText, true);
        }

        private String getUnitString(TimeUnit unit, boolean shortText, boolean force) {
            StringBuilder text = new StringBuilder();
            long count = this.getUnitValue(unit);
            if (count > 0L || force) {
                text.append(count).append(shortText ? unit.getShortText().getString() : (count != 1L ? unit.getPluralText().getString() : unit.getText().getString()));
            }
            return text.toString();
        }

        public String getString() {
            return this.getString(false, Integer.MAX_VALUE);
        }

        public String getString(int maxCount) {
            return this.getString(false, maxCount);
        }

        public String getShortString() {
            return this.getString(true, Integer.MAX_VALUE);
        }

        public String getShortString(int maxCount) {
            return this.getString(true, maxCount);
        }

        private String getString(boolean shortText, int maxCount) {
            StringBuilder text = new StringBuilder();
            int count = 0;
            for (int i = 0; i < TimeUnit.UNITS_LARGE_TO_SMALL.size() && count < maxCount; ++i) {
                TimeUnit unit = TimeUnit.UNITS_LARGE_TO_SMALL.get(i);
                String unitText = this.getUnitString(unit, shortText, false);
                if (unitText.length() <= 0) continue;
                if (text.length() > 0) {
                    text.append(" ");
                }
                text.append(unitText);
                ++count;
            }
            return text.toString();
        }
    }

    public static enum TimeUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY;

        public static final List<TimeUnit> UNITS_SMALL_TO_LARGE;
        public static final List<TimeUnit> UNITS_LARGE_TO_SMALL;

        public MutableComponent getText() {
            return Component.m_237115_((String)("gui.lightmanscurrency.time.unit." + this.name().toLowerCase()));
        }

        public MutableComponent getPluralText() {
            return Component.m_237115_((String)("gui.lightmanscurrency.time.unit." + this.name().toLowerCase() + ".plural"));
        }

        public MutableComponent getShortText() {
            return Component.m_237115_((String)("gui.lightmanscurrency.time.unit." + this.name().toLowerCase() + ".short"));
        }

        static {
            UNITS_SMALL_TO_LARGE = ImmutableList.of((Object)((Object)SECOND), (Object)((Object)MINUTE), (Object)((Object)HOUR), (Object)((Object)DAY));
            UNITS_LARGE_TO_SMALL = ImmutableList.of((Object)((Object)DAY), (Object)((Object)HOUR), (Object)((Object)MINUTE), (Object)((Object)SECOND));
        }
    }
}

