/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenWalletBank {
    private final int walletStackIndex;

    public MessageOpenWalletBank(int walletStackIndex) {
        this.walletStackIndex = walletStackIndex;
    }

    public static void encode(MessageOpenWalletBank message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.walletStackIndex);
    }

    public static MessageOpenWalletBank decode(FriendlyByteBuf buffer) {
        return new MessageOpenWalletBank(buffer.readInt());
    }

    public static void handle(MessageOpenWalletBank message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                WalletMenuBase.SafeOpenWalletBankMenu(player, message.walletStackIndex);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

