/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageTraderMessage {
    long traderID;
    CompoundTag message;

    public MessageTraderMessage(long traderID, CompoundTag message) {
        this.traderID = traderID;
        this.message = message;
    }

    public static void encode(MessageTraderMessage message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.traderID);
        buffer.m_130079_(message.message);
    }

    public static MessageTraderMessage decode(FriendlyByteBuf buffer) {
        return new MessageTraderMessage(buffer.readLong(), buffer.m_130261_());
    }

    public static void handle(MessageTraderMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TraderData trader;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (trader = TraderSaveData.GetTrader(false, message.traderID)) != null) {
                trader.receiveNetworkMessage((Player)player, message.message);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

