/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenTrades {
    private final long traderID;

    public MessageOpenTrades(long traderID) {
        this.traderID = traderID;
    }

    public static void encode(MessageOpenTrades message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.traderID);
    }

    public static MessageOpenTrades decode(FriendlyByteBuf buffer) {
        return new MessageOpenTrades(buffer.readLong());
    }

    public static void handle(MessageOpenTrades message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                TraderData data;
                MenuValidator validator = SimpleValidator.NULL;
                AbstractContainerMenu patt1368$temp = player.f_36096_;
                if (patt1368$temp instanceof IValidatedMenu) {
                    IValidatedMenu tm = (IValidatedMenu)patt1368$temp;
                    validator = tm.getValidator();
                }
                if ((data = TraderSaveData.GetTrader(false, message.traderID)) != null) {
                    data.openTraderMenu((Player)player, validator);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

