/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenStorage {
    private final long traderID;

    public MessageOpenStorage(long traderID) {
        this.traderID = traderID;
    }

    public static void encode(MessageOpenStorage message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.traderID);
    }

    public static MessageOpenStorage decode(FriendlyByteBuf buffer) {
        return new MessageOpenStorage(buffer.readLong());
    }

    public static void handle(MessageOpenStorage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                TraderData trader;
                MenuValidator validator = SimpleValidator.NULL;
                AbstractContainerMenu patt1376$temp = player.f_36096_;
                if (patt1376$temp instanceof IValidatedMenu) {
                    IValidatedMenu tm = (IValidatedMenu)patt1376$temp;
                    validator = tm.getValidator();
                }
                if ((trader = TraderSaveData.GetTrader(false, message.traderID)) != null) {
                    trader.openStorageMenu((Player)player, validator);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

