/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddOrRemoveTrade {
    long traderID;
    boolean isTradeAdd;

    public MessageAddOrRemoveTrade(long traderID, boolean isTradeAdd) {
        this.traderID = traderID;
        this.isTradeAdd = isTradeAdd;
    }

    public static void encode(MessageAddOrRemoveTrade message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.traderID);
        buffer.writeBoolean(message.isTradeAdd);
    }

    public static MessageAddOrRemoveTrade decode(FriendlyByteBuf buffer) {
        return new MessageAddOrRemoveTrade(buffer.readLong(), buffer.readBoolean());
    }

    public static void handle(MessageAddOrRemoveTrade message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TraderData trader;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (trader = TraderSaveData.GetTrader(false, message.traderID)) != null) {
                if (message.isTradeAdd) {
                    trader.addTrade((Player)player);
                } else {
                    trader.removeTrade((Player)player);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

