/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.teams;

import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetTeamBankLimit {
    long teamID;
    int newLimit;

    public MessageSetTeamBankLimit(long teamID, int newLimit) {
        this.teamID = teamID;
        this.newLimit = newLimit;
    }

    public static void encode(MessageSetTeamBankLimit message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.teamID);
        buffer.writeInt(message.newLimit);
    }

    public static MessageSetTeamBankLimit decode(FriendlyByteBuf buffer) {
        return new MessageSetTeamBankLimit(buffer.readLong(), buffer.readInt());
    }

    public static void handle(MessageSetTeamBankLimit message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Team team = TeamSaveData.GetTeam(false, message.teamID);
            if (team != null) {
                team.changeBankLimit((Player)((NetworkEvent.Context)supplier.get()).getSender(), message.newLimit);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

