/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.teams;

import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageRenameTeam {
    long teamID;
    String newName;

    public MessageRenameTeam(long teamID, String newName) {
        this.teamID = teamID;
        this.newName = newName;
    }

    public static void encode(MessageRenameTeam message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.teamID);
        buffer.m_130072_(message.newName, 32);
    }

    public static MessageRenameTeam decode(FriendlyByteBuf buffer) {
        return new MessageRenameTeam(buffer.readLong(), buffer.m_130136_(32));
    }

    public static void handle(MessageRenameTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Team team = TeamSaveData.GetTeam(false, message.teamID);
            if (team != null) {
                team.changeName((Player)((NetworkEvent.Context)supplier.get()).getSender(), message.newName);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

