/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.teams;

import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageCreateTeamBankAccount {
    long teamID;

    public MessageCreateTeamBankAccount(long teamID) {
        this.teamID = teamID;
    }

    public static void encode(MessageCreateTeamBankAccount message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.teamID);
    }

    public static MessageCreateTeamBankAccount decode(FriendlyByteBuf buffer) {
        return new MessageCreateTeamBankAccount(buffer.readLong());
    }

    public static void handle(MessageCreateTeamBankAccount message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Team team = TeamSaveData.GetTeam(false, message.teamID);
            if (team != null) {
                team.createBankAccount((Player)((NetworkEvent.Context)supplier.get()).getSender());
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

