/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddPersistentTrader {
    private static final String GENERATE_ID_FORMAT = "trader_";
    final long traderID;
    final String id;
    final String owner;

    public MessageAddPersistentTrader(long traderID, String id, String owner) {
        this.traderID = traderID;
        this.id = id;
        this.owner = owner.isBlank() ? "Minecraft" : owner;
    }

    public static void encode(MessageAddPersistentTrader message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.traderID);
        buffer.m_130070_(message.id);
        buffer.m_130070_(message.owner);
    }

    public static MessageAddPersistentTrader decode(FriendlyByteBuf buffer) {
        return new MessageAddPersistentTrader(buffer.readLong(), buffer.m_130277_(), buffer.m_130277_());
    }

    public static void handle(MessageAddPersistentTrader message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TraderData trader;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (CommandLCAdmin.isAdminPlayer((Player)player) && (trader = TraderSaveData.GetTrader(false, message.traderID)) != null && trader.canMakePersistent()) {
                boolean generateID = message.id.isBlank();
                if (!generateID) {
                    try {
                        JsonObject traderJson = trader.saveToJson(message.id, message.owner);
                        JsonArray persistentTraders = TraderSaveData.getPersistentTraderJson("Traders");
                        for (int i = 0; i < persistentTraders.size(); ++i) {
                            JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                            if ((!traderData.has("ID") || !traderData.get("ID").getAsString().equals(message.id)) && (!traderData.has("id") || !traderData.get("id").getAsString().equals(message.id))) continue;
                            persistentTraders.set(i, (JsonElement)traderJson);
                            TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                            player.m_213846_((Component)Component.m_237110_((String)"lightmanscurrency.message.persistent.trader.overwrite", (Object[])new Object[]{message.id}));
                            return;
                        }
                        persistentTraders.add((JsonElement)traderJson);
                        TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                        player.m_213846_((Component)Component.m_237110_((String)"lightmanscurrency.message.persistent.trader.add", (Object[])new Object[]{message.id}));
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else {
                    try {
                        int i;
                        ArrayList<String> knownIDs = new ArrayList<String>();
                        JsonArray persistentTraders = TraderSaveData.getPersistentTraderJson("Traders");
                        for (i = 0; i < persistentTraders.size(); ++i) {
                            JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                            if (traderData.has("id")) {
                                knownIDs.add(traderData.get("id").getAsString());
                            }
                            if (!traderData.has("ID")) continue;
                            knownIDs.add(traderData.get("ID").getAsString());
                        }
                        for (i = 1; i < Integer.MAX_VALUE; ++i) {
                            String genID = GENERATE_ID_FORMAT + i;
                            if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                            persistentTraders.add((JsonElement)trader.saveToJson(genID, message.owner));
                            TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                            player.m_213846_((Component)Component.m_237110_((String)"lightmanscurrency.message.persistent.trader.add", (Object[])new Object[]{genID}));
                            return;
                        }
                        LightmansCurrency.LogError("Could not generate ID, as all trader_# ID's are somehow spoken for.");
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            player.m_213846_((Component)Component.m_237115_((String)"lightmanscurrency.message.persistent.trader.fail"));
        });
        supplier.get().setPacketHandled(true);
    }
}

